"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const ouia_1 = require("@patternfly/react-core/dist/js/helpers/ouia");
const util_1 = require("@patternfly/react-core/dist/js/helpers/util");
const table_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Table/table"));
const inline_edit_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/InlineEdit/inline-edit"));
const react_styles_1 = require("@patternfly/react-styles");
class RowWrapper extends React.Component {
    constructor(props) {
        super(props);
        this.handleScroll = (event) => {
            if (!this._unmounted) {
                this.props.onScroll(event);
            }
        };
        this.handleResize = (event) => {
            if (!this._unmounted) {
                this.props.onResize(event);
            }
        };
        if (props.onScroll) {
            this.handleScroll = util_1.debounce(this.handleScroll, 100);
        }
        if (props.onResize) {
            this.handleResize = util_1.debounce(this.handleResize, 100);
        }
        this.state = {
            ouiaStateId: ouia_1.getDefaultOUIAId('TableRow')
        };
    }
    componentDidMount() {
        this._unmounted = false;
        if (this.props.onScroll) {
            window.addEventListener('scroll', this.handleScroll);
        }
        if (this.props.onResize) {
            window.addEventListener('resize', this.handleResize);
        }
    }
    componentWillUnmount() {
        this._unmounted = true;
        if (this.props.onScroll) {
            window.removeEventListener('scroll', this.handleScroll);
        }
        if (this.props.onResize) {
            window.removeEventListener('resize', this.handleResize);
        }
    }
    render() {
        const _a = this.props, { 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        onScroll, onResize, row: { isExpanded, isEditable }, rowProps, 
        /* eslint-enable @typescript-eslint/no-unused-vars */
        trRef, className, ouiaId } = _a, props = tslib_1.__rest(_a, ["onScroll", "onResize", "row", "rowProps", "trRef", "className", "ouiaId"]);
        return (React.createElement("tr", Object.assign({}, props, { ref: trRef, className: react_styles_1.css(className, isExpanded !== undefined && table_1.default.tableExpandableRow, isExpanded && table_1.default.modifiers.expanded, isEditable && inline_edit_1.default.modifiers.inlineEditable), hidden: isExpanded !== undefined && !isExpanded }, ouia_1.getOUIAProps('TableRow', ouiaId !== undefined ? ouiaId : this.state.ouiaStateId))));
    }
}
exports.RowWrapper = RowWrapper;
RowWrapper.displayName = 'RowWrapper';
RowWrapper.defaultProps = {
    className: '',
    row: {
        isOpen: undefined,
        isExpanded: undefined,
        isHeightAuto: undefined,
        isEditable: undefined
    },
    rowProps: null
};
//# sourceMappingURL=RowWrapper.js.map