---
id: Card
section: components
wrapperTag: div
---## Demos

### Card view

```html isFullscreen
<div class="pf-c-page" id="card-view">
  <a class="pf-c-skip-to-content pf-c-button pf-m-primary" href="#main-content-card-view">Skip to content</a>
  <header class="pf-c-page__header">
    <div class="pf-c-page__header-brand">
      <div class="pf-c-page__header-brand-toggle">
        <button class="pf-c-button pf-m-plain" type="button" id="card-view-nav-toggle" aria-label="Global navigation" aria-expanded="true" aria-controls="card-view-primary-nav">
          <i class="fas fa-bars" aria-hidden="true"></i>
        </button>
      </div>
      <a href="#" class="pf-c-page__header-brand-link">
        <img class="pf-c-brand" src="/assets/images/PF-Masthead-Logo.svg" alt="Patternfly Logo" />
      </a>
    </div>
    <div class="pf-c-page__header-tools">
      <div class="pf-c-page__header-tools-group">
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Settings">
            <i class="fas fa-cog" aria-hidden="true"></i>
          </button>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-lg">
          <button class="pf-c-button pf-m-plain" type="button" aria-label="Help">
            <i class="pf-icon pf-icon-help" aria-hidden="true"></i>
          </button>
        </div>
      </div>
      <div class="pf-c-page__header-tools-group">
        <div class="pf-c-page__header-tools-item pf-m-hidden-on-lg">
          <div class="pf-c-dropdown">
            <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="card-view-dropdown-kebab-right-aligned-1-button" aria-expanded="false" aria-label="Actions">
              <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
            </button>
            <ul class="pf-c-dropdown__menu pf-m-align-right" aria-labelledby="card-view-dropdown-kebab-right-aligned-1-button" hidden>
              <li>
                <a class="pf-c-dropdown__menu-item" href="#">Link</a>
              </li>
              <li>
                <button class="pf-c-dropdown__menu-item" type="button">Action</button>
              </li>
              <li>
                <a class="pf-c-dropdown__menu-item pf-m-disabled" href="#" aria-disabled="true" tabindex="-1">Disabled link</a>
              </li>
              <li>
                <button class="pf-c-dropdown__menu-item" type="button" disabled>Disabled action</button>
              </li>
              <li class="pf-c-divider" role="separator"></li>
              <li>
                <a class="pf-c-dropdown__menu-item" href="#">Separated link</a>
              </li>
            </ul>
          </div>
        </div>
        <div class="pf-c-page__header-tools-item pf-m-hidden pf-m-visible-on-md">
          <div class="pf-c-dropdown">
            <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="card-view-dropdown-button" aria-expanded="false">
              <span class="pf-c-dropdown__toggle-text">John Smith</span>
              <span class="pf-c-dropdown__toggle-icon">
                <i class="fas fa-caret-down" aria-hidden="true"></i>
              </span>
            </button>
            <div class="pf-c-dropdown__menu" hidden>[Panel contents here]</div>
          </div>
        </div>
      </div>
      <img class="pf-c-avatar" src="/assets/images/img_avatar.svg" alt="Avatar image" />
    </div>
  </header>
  <div class="pf-c-page__sidebar">
    <div class="pf-c-page__sidebar-body">
      <nav class="pf-c-nav" id="card-view-primary-nav" aria-label="Global">
        <ul class="pf-c-nav__list">
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link pf-m-current" aria-current="page">System Panel</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Policy</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Authentication</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Network Services</a>
          </li>
          <li class="pf-c-nav__item">
            <a href="#" class="pf-c-nav__link">Server</a>
          </li>
        </ul>
      </nav>
    </div>
  </div>
  <main class="pf-c-page__main" tabindex="-1" id="main-content-card-view">
    <section class="pf-c-page__main-section pf-m-light">
      <div class="pf-c-content">
        <h1>Projects</h1>
        <p>This is a demo that showcases Patternfly Cards.</p>
      </div>
    </section>
    <section class="pf-c-page__main-section">
      <div class="pf-l-gallery pf-m-gutter">
        <div class="pf-c-card pf-m-hoverable pf-m-compact" id="card-1">
          <div class="pf-c-card__header">
            <img src="/assets/images/pf-logo-small.svg" alt="PatternFly logo" />
            <div class="pf-c-card__actions">
              <div class="pf-c-dropdown">
                <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="card-1-dropdown-kebab-right-aligned-button" aria-expanded="false" aria-label="Actions">
                  <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                </button>
                <ul class="pf-c-dropdown__menu" aria-labelledby="card-1-dropdown-kebab-right-aligned-button" hidden>
                  <li>
                    <a class="pf-c-dropdown__menu-item" href="#">Link</a>
                  </li>
                  <li>
                    <button class="pf-c-dropdown__menu-item" type="button">Action</button>
                  </li>
                  <li>
                    <a class="pf-c-dropdown__menu-item pf-m-disabled" href="#" aria-disabled="true" tabindex="-1">Disabled link</a>
                  </li>
                  <li>
                    <button class="pf-c-dropdown__menu-item" type="button" disabled>Disabled action</button>
                  </li>
                  <li class="pf-c-divider" role="separator"></li>
                  <li>
                    <a class="pf-c-dropdown__menu-item" href="#">Separated link</a>
                  </li>
                </ul>
              </div>
              <input type="checkbox" id="card-1-check" name="card-1-check" aria-labelledby="card-1-check-label" />
            </div>
          </div>
          <div class="pf-c-card__title">
            <p id="card-1-check-label">Patternfly</p>
            <div class="pf-c-content">
              <small>Provided by Red Hat</small>
            </div>
          </div>
          <div class="pf-c-card__body">PatternFly is a community project that promotes design commonality and improves user experience.</div>
        </div>
        <div class="pf-c-card pf-m-hoverable pf-m-compact" id="card-2">
          <div class="pf-c-card__header">
            <img src="/assets/images/activemq-core_200x150.png" width="60px" alt="Logo" />
            <div class="pf-c-card__actions">
              <div class="pf-c-dropdown">
                <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="card-2-dropdown-kebab-right-aligned-button" aria-expanded="false" aria-label="Actions">
                  <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                </button>
                <ul class="pf-c-dropdown__menu" aria-labelledby="card-2-dropdown-kebab-right-aligned-button" hidden>
                  <li>
                    <a class="pf-c-dropdown__menu-item" href="#">Link</a>
                  </li>
                  <li>
                    <button class="pf-c-dropdown__menu-item" type="button">Action</button>
                  </li>
                  <li>
                    <a class="pf-c-dropdown__menu-item pf-m-disabled" href="#" aria-disabled="true" tabindex="-1">Disabled link</a>
                  </li>
                  <li>
                    <button class="pf-c-dropdown__menu-item" type="button" disabled>Disabled action</button>
                  </li>
                  <li class="pf-c-divider" role="separator"></li>
                  <li>
                    <a class="pf-c-dropdown__menu-item" href="#">Separated link</a>
                  </li>
                </ul>
              </div>
              <input type="checkbox" id="card-2-check" name="card-2-check" aria-labelledby="card-2-check-label" />
            </div>
          </div>
          <div class="pf-c-card__title">
            <p id="card-2-check-label">ActiveMQ</p>
            <div class="pf-c-content">
              <small>Provided by Red Hat</small>
            </div>
          </div>
          <div class="pf-c-card__body">The ActiveMQ component allows messages to be sent to a JMS Queue or Topic; or messages to be consumed from a JMS Queue or Topic using Apache ActiveMQ.</div>
        </div>
        <div class="pf-c-card pf-m-hoverable pf-m-compact" id="card-3">
          <div class="pf-c-card__header">
            <img src="/assets/images/camel-spark_200x150.png" width="60px" alt="Logo" />
            <div class="pf-c-card__actions">
              <div class="pf-c-dropdown">
                <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="card-3-dropdown-kebab-right-aligned-button" aria-expanded="false" aria-label="Actions">
                  <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                </button>
                <ul class="pf-c-dropdown__menu" aria-labelledby="card-3-dropdown-kebab-right-aligned-button" hidden>
                  <li>
                    <a class="pf-c-dropdown__menu-item" href="#">Link</a>
                  </li>
                  <li>
                    <button class="pf-c-dropdown__menu-item" type="button">Action</button>
                  </li>
                  <li>
                    <a class="pf-c-dropdown__menu-item pf-m-disabled" href="#" aria-disabled="true" tabindex="-1">Disabled link</a>
                  </li>
                  <li>
                    <button class="pf-c-dropdown__menu-item" type="button" disabled>Disabled action</button>
                  </li>
                  <li class="pf-c-divider" role="separator"></li>
                  <li>
                    <a class="pf-c-dropdown__menu-item" href="#">Separated link</a>
                  </li>
                </ul>
              </div>
              <input type="checkbox" id="card-3-check" name="card-3-check" aria-labelledby="card-3-check-label" />
            </div>
          </div>
          <div class="pf-c-card__title">
            <p id="card-3-check-label">Apache Spark</p>
            <div class="pf-c-content">
              <small>Provided by Red Hat</small>
            </div>
          </div>
          <div class="pf-c-card__body">This documentation page covers the Apache Spark component for the Apache Camel.</div>
        </div>
        <div class="pf-c-card pf-m-hoverable pf-m-compact" id="card-4">
          <div class="pf-c-card__header">
            <img src="/assets/images/camel-avro_200x150.png" width="60px" alt="Logo" />
            <div class="pf-c-card__actions">
              <div class="pf-c-dropdown">
                <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="card-4-dropdown-kebab-right-aligned-button" aria-expanded="false" aria-label="Actions">
                  <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                </button>
                <ul class="pf-c-dropdown__menu" aria-labelledby="card-4-dropdown-kebab-right-aligned-button" hidden>
                  <li>
                    <a class="pf-c-dropdown__menu-item" href="#">Link</a>
                  </li>
                  <li>
                    <button class="pf-c-dropdown__menu-item" type="button">Action</button>
                  </li>
                  <li>
                    <a class="pf-c-dropdown__menu-item pf-m-disabled" href="#" aria-disabled="true" tabindex="-1">Disabled link</a>
                  </li>
                  <li>
                    <button class="pf-c-dropdown__menu-item" type="button" disabled>Disabled action</button>
                  </li>
                  <li class="pf-c-divider" role="separator"></li>
                  <li>
                    <a class="pf-c-dropdown__menu-item" href="#">Separated link</a>
                  </li>
                </ul>
              </div>
              <input type="checkbox" id="card-4-check" name="card-4-check" aria-labelledby="card-4-check-label" />
            </div>
          </div>
          <div class="pf-c-card__title">
            <p id="card-4-check-label">Avro</p>
            <div class="pf-c-content">
              <small>Provided by Red Hat</small>
            </div>
          </div>
          <div class="pf-c-card__body">This component provides a dataformat for avro, which allows serialization and deserialization of messages using Apache Avro’s binary dataformat. Moreover, it provides support for Apache Avro’s rpc, by providing producers and consumers endpoint for using avro over netty or http.</div>
        </div>
        <div class="pf-c-card pf-m-hoverable pf-m-compact" id="card-5">
          <div class="pf-c-card__header">
            <img src="/assets/images/FuseConnector_Icons_AzureServices.png" width="60px" alt="Logo" />
            <div class="pf-c-card__actions">
              <div class="pf-c-dropdown">
                <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="card-5-dropdown-kebab-right-aligned-button" aria-expanded="false" aria-label="Actions">
                  <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                </button>
                <ul class="pf-c-dropdown__menu" aria-labelledby="card-5-dropdown-kebab-right-aligned-button" hidden>
                  <li>
                    <a class="pf-c-dropdown__menu-item" href="#">Link</a>
                  </li>
                  <li>
                    <button class="pf-c-dropdown__menu-item" type="button">Action</button>
                  </li>
                  <li>
                    <a class="pf-c-dropdown__menu-item pf-m-disabled" href="#" aria-disabled="true" tabindex="-1">Disabled link</a>
                  </li>
                  <li>
                    <button class="pf-c-dropdown__menu-item" type="button" disabled>Disabled action</button>
                  </li>
                  <li class="pf-c-divider" role="separator"></li>
                  <li>
                    <a class="pf-c-dropdown__menu-item" href="#">Separated link</a>
                  </li>
                </ul>
              </div>
              <input type="checkbox" id="card-5-check" name="card-5-check" aria-labelledby="card-5-check-label" />
            </div>
          </div>
          <div class="pf-c-card__title">
            <p id="card-5-check-label">Azure Services</p>
            <div class="pf-c-content">
              <small>Provided by Red Hat</small>
            </div>
          </div>
          <div class="pf-c-card__body">The Camel Components for Windows Azure Services provide connectivity to Azure services from Camel.</div>
        </div>
        <div class="pf-c-card pf-m-hoverable pf-m-compact" id="card-6">
          <div class="pf-c-card__header">
            <img src="/assets/images/camel-saxon_200x150.png" width="60px" alt="Logo" />
            <div class="pf-c-card__actions">
              <div class="pf-c-dropdown">
                <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="card-6-dropdown-kebab-right-aligned-button" aria-expanded="false" aria-label="Actions">
                  <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                </button>
                <ul class="pf-c-dropdown__menu" aria-labelledby="card-6-dropdown-kebab-right-aligned-button" hidden>
                  <li>
                    <a class="pf-c-dropdown__menu-item" href="#">Link</a>
                  </li>
                  <li>
                    <button class="pf-c-dropdown__menu-item" type="button">Action</button>
                  </li>
                  <li>
                    <a class="pf-c-dropdown__menu-item pf-m-disabled" href="#" aria-disabled="true" tabindex="-1">Disabled link</a>
                  </li>
                  <li>
                    <button class="pf-c-dropdown__menu-item" type="button" disabled>Disabled action</button>
                  </li>
                  <li class="pf-c-divider" role="separator"></li>
                  <li>
                    <a class="pf-c-dropdown__menu-item" href="#">Separated link</a>
                  </li>
                </ul>
              </div>
              <input type="checkbox" id="card-6-check" name="card-6-check" aria-labelledby="card-6-check-label" />
            </div>
          </div>
          <div class="pf-c-card__title">
            <p id="card-6-check-label">Crypto</p>
            <div class="pf-c-content">
              <small>Provided by Red Hat</small>
            </div>
          </div>
          <div class="pf-c-card__body">For providing flexible endpoints to sign and verify exchanges using the Signature Service of the Java Cryptographic Extension.</div>
        </div>
        <div class="pf-c-card pf-m-hoverable pf-m-compact" id="card-7">
          <div class="pf-c-card__header">
            <img src="/assets/images/camel-dropbox_200x150.png" width="60px" alt="Logo" />
            <div class="pf-c-card__actions">
              <div class="pf-c-dropdown">
                <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="card-7-dropdown-kebab-right-aligned-button" aria-expanded="false" aria-label="Actions">
                  <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                </button>
                <ul class="pf-c-dropdown__menu" aria-labelledby="card-7-dropdown-kebab-right-aligned-button" hidden>
                  <li>
                    <a class="pf-c-dropdown__menu-item" href="#">Link</a>
                  </li>
                  <li>
                    <button class="pf-c-dropdown__menu-item" type="button">Action</button>
                  </li>
                  <li>
                    <a class="pf-c-dropdown__menu-item pf-m-disabled" href="#" aria-disabled="true" tabindex="-1">Disabled link</a>
                  </li>
                  <li>
                    <button class="pf-c-dropdown__menu-item" type="button" disabled>Disabled action</button>
                  </li>
                  <li class="pf-c-divider" role="separator"></li>
                  <li>
                    <a class="pf-c-dropdown__menu-item" href="#">Separated link</a>
                  </li>
                </ul>
              </div>
              <input type="checkbox" id="card-7-check" name="card-7-check" aria-labelledby="card-7-check-label" />
            </div>
          </div>
          <div class="pf-c-card__title">
            <p id="card-7-check-label">DropBox</p>
            <div class="pf-c-content">
              <small>Provided by Red Hat</small>
            </div>
          </div>
          <div class="pf-c-card__body">The dropbox: component allows you to treat Dropbox remote folders as a producer or consumer of messages.</div>
        </div>
        <div class="pf-c-card pf-m-hoverable pf-m-compact" id="card-8">
          <div class="pf-c-card__header">
            <img src="/assets/images/camel-infinispan_200x150.png" width="60px" alt="Logo" />
            <div class="pf-c-card__actions">
              <div class="pf-c-dropdown">
                <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="card-8-dropdown-kebab-right-aligned-button" aria-expanded="false" aria-label="Actions">
                  <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                </button>
                <ul class="pf-c-dropdown__menu" aria-labelledby="card-8-dropdown-kebab-right-aligned-button" hidden>
                  <li>
                    <a class="pf-c-dropdown__menu-item" href="#">Link</a>
                  </li>
                  <li>
                    <button class="pf-c-dropdown__menu-item" type="button">Action</button>
                  </li>
                  <li>
                    <a class="pf-c-dropdown__menu-item pf-m-disabled" href="#" aria-disabled="true" tabindex="-1">Disabled link</a>
                  </li>
                  <li>
                    <button class="pf-c-dropdown__menu-item" type="button" disabled>Disabled action</button>
                  </li>
                  <li class="pf-c-divider" role="separator"></li>
                  <li>
                    <a class="pf-c-dropdown__menu-item" href="#">Separated link</a>
                  </li>
                </ul>
              </div>
              <input type="checkbox" id="card-8-check" name="card-8-check" aria-labelledby="card-8-check-label" />
            </div>
          </div>
          <div class="pf-c-card__title">
            <p id="card-8-check-label">JBoss Data Grid</p>
            <div class="pf-c-content">
              <small>Provided by Red Hat</small>
            </div>
          </div>
          <div class="pf-c-card__body">Read or write to a fully-supported distributed cache and data grid for faster integration services.</div>
        </div>
        <div class="pf-c-card pf-m-hoverable pf-m-compact" id="card-9">
          <div class="pf-c-card__header">
            <img src="/assets/images/FuseConnector_Icons_REST.png" width="60px" alt="Logo" />
            <div class="pf-c-card__actions">
              <div class="pf-c-dropdown">
                <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="card-9-dropdown-kebab-right-aligned-button" aria-expanded="false" aria-label="Actions">
                  <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                </button>
                <ul class="pf-c-dropdown__menu" aria-labelledby="card-9-dropdown-kebab-right-aligned-button" hidden>
                  <li>
                    <a class="pf-c-dropdown__menu-item" href="#">Link</a>
                  </li>
                  <li>
                    <button class="pf-c-dropdown__menu-item" type="button">Action</button>
                  </li>
                  <li>
                    <a class="pf-c-dropdown__menu-item pf-m-disabled" href="#" aria-disabled="true" tabindex="-1">Disabled link</a>
                  </li>
                  <li>
                    <button class="pf-c-dropdown__menu-item" type="button" disabled>Disabled action</button>
                  </li>
                  <li class="pf-c-divider" role="separator"></li>
                  <li>
                    <a class="pf-c-dropdown__menu-item" href="#">Separated link</a>
                  </li>
                </ul>
              </div>
              <input type="checkbox" id="card-9-check" name="card-9-check" aria-labelledby="card-9-check-label" />
            </div>
          </div>
          <div class="pf-c-card__title">
            <p id="card-9-check-label">REST</p>
            <div class="pf-c-content">
              <small>Provided by Red Hat</small>
            </div>
          </div>
          <div class="pf-c-card__body">The rest component allows to define REST endpoints (consumer) using the Rest DSL and plugin to other Camel components as the REST transport. From Camel 2.18 onwards the rest component can also be used as a client (producer) to call REST services.</div>
        </div>
        <div class="pf-c-card pf-m-hoverable pf-m-compact" id="card-10">
          <div class="pf-c-card__header">
            <img src="/assets/images/camel-swagger-java_200x150.png" width="60px" alt="Logo" />
            <div class="pf-c-card__actions">
              <div class="pf-c-dropdown">
                <button class="pf-c-dropdown__toggle pf-m-plain" type="button" id="card-10-dropdown-kebab-right-aligned-button" aria-expanded="false" aria-label="Actions">
                  <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                </button>
                <ul class="pf-c-dropdown__menu" aria-labelledby="card-10-dropdown-kebab-right-aligned-button" hidden>
                  <li>
                    <a class="pf-c-dropdown__menu-item" href="#">Link</a>
                  </li>
                  <li>
                    <button class="pf-c-dropdown__menu-item" type="button">Action</button>
                  </li>
                  <li>
                    <a class="pf-c-dropdown__menu-item pf-m-disabled" href="#" aria-disabled="true" tabindex="-1">Disabled link</a>
                  </li>
                  <li>
                    <button class="pf-c-dropdown__menu-item" type="button" disabled>Disabled action</button>
                  </li>
                  <li class="pf-c-divider" role="separator"></li>
                  <li>
                    <a class="pf-c-dropdown__menu-item" href="#">Separated link</a>
                  </li>
                </ul>
              </div>
              <input type="checkbox" id="card-10-check" name="card-10-check" aria-labelledby="card-10-check-label" />
            </div>
          </div>
          <div class="pf-c-card__title">
            <p id="card-10-check-label">SWAGGER</p>
            <div class="pf-c-content">
              <small>Provided by Red Hat</small>
            </div>
          </div>
          <div class="pf-c-card__body">Expose REST services and their APIs using Swagger specification.</div>
        </div>
      </div>
    </section>
  </main>
</div>
```
