---
id: Form
section: components
---## Demos

### Basic

```html
<form novalidate class="pf-c-form">
  <div class="pf-c-form__group">
    <div class="pf-c-form__group-label">
      <label class="pf-c-form__label" for="simple-form-name">
        <span class="pf-c-form__label-text">Name</span>
        <span class="pf-c-form__label-required" aria-hidden="true">&#42;</span>
      </label>
    </div>
    <div class="pf-c-form__group-control">
      <input class="pf-c-form-control" required type="text" id="simple-form-name" name="simple-form-name" aria-describedby="simple-form-name-helper-1" />
      <p class="pf-c-form__helper-text" id="simple-form-name-helper-1" aria-live="polite">Please provide your full name</p>
    </div>
  </div>
  <div class="pf-c-form__group">
    <div class="pf-c-form__group-label">
      <label class="pf-c-form__label" for="simple-form-email">
        <span class="pf-c-form__label-text">Email</span>
        <span class="pf-c-form__label-required" aria-hidden="true">&#42;</span>
      </label>
    </div>
    <div class="pf-c-form__group-control">
      <input class="pf-c-form-control" required type="email" id="simple-form-email" name="simple-form-email" />
    </div>
  </div>
  <div class="pf-c-form__group">
    <div class="pf-c-form__group-label">
      <label class="pf-c-form__label" for="simple-form-number">
        <span class="pf-c-form__label-text">Phone number</span>
      </label>
    </div>
    <div class="pf-c-form__group-control">
      <input class="pf-c-form-control" type="tel" id="simple-form-number" name="simple-form-number" placeholder="555-555-5555" />
    </div>
  </div>
  <div class="pf-c-form__group">
    <div class="pf-c-form__group-label">
      <label class="pf-c-form__label">
        <span class="pf-c-form__label-text">How can we contact you?</span>
        <span class="pf-c-form__label-required" aria-hidden="true">&#42;</span>
      </label>
    </div>
    <div class="pf-c-form__group-control pf-m-inline">
      <div class="pf-c-check">
        <input class="pf-c-check__input" type="checkbox" type="radio" id="inlineradio1" name="inlineradio1" required />
        <label class="pf-c-check__label" for="inlineradio1">Email</label>
      </div>
      <div class="pf-c-check">
        <input class="pf-c-check__input" type="checkbox" type="radio" id="inlineradio2" name="inlineradio2" />
        <label class="pf-c-check__label" for="inlineradio2">Phone</label>
      </div>
      <div class="pf-c-check">
        <input class="pf-c-check__input" type="checkbox" type="radio" id="inlineradio3" name="inlineradio3" />
        <label class="pf-c-check__label" for="inlineradio3">Please don't contact me</label>
      </div>
    </div>
  </div>
  <div class="pf-c-form__group">
    <div class="pf-c-form__group-control">
      <div class="pf-c-check">
        <input class="pf-c-check__input" type="checkbox" type="checkbox" id="checkbox1" name="checkbox1" />
        <label class="pf-c-check__label" for="checkbox1">I'd like updates via email</label>
      </div>
    </div>
  </div>
  <div class="pf-c-form__group pf-m-action">
    <div class="pf-c-form__group-control">
      <div class="pf-c-form__actions">
        <button class="pf-c-button pf-m-primary" type="submit">Submit form</button>
        <button class="pf-c-button pf-m-secondary" type="button">Cancel</button>
      </div>
    </div>
  </div>
</form>
```

### Horizontal

```html
<form novalidate class="pf-c-form pf-m-horizontal">
  <div class="pf-c-form__group">
    <div class="pf-c-form__group-label">
      <label class="pf-c-form__label" for="horizontal-form-name">
        <span class="pf-c-form__label-text">Name</span>
        <span class="pf-c-form__label-required" aria-hidden="true">&#42;</span>
      </label>
    </div>
    <div class="pf-c-form__group-control">
      <input class="pf-c-form-control" required type="text" id="horizontal-form-name" name="horizontal-form-name" aria-describedby="horizontal-form-name-helper2" />
      <p class="pf-c-form__helper-text" id="horizontal-form-name-helper2" aria-live="polite">Please provide your full name</p>
    </div>
  </div>
  <div class="pf-c-form__group">
    <div class="pf-c-form__group-label">
      <label class="pf-c-form__label" for="horizontal-form-email">
        <span class="pf-c-form__label-text">Email</span>
      </label>
    </div>
    <div class="pf-c-form__group-control">
      <input class="pf-c-form-control" type="email" id="horizontal-form-email" name="horizontal-form-email" />
    </div>
  </div>
  <div class="pf-c-form__group">
    <div class="pf-c-form__group-label">
      <label class="pf-c-form__label" for="horizontal-form-title">
        <span class="pf-c-form__label-text">Your title</span>
      </label>
    </div>
    <div class="pf-c-form__group-control">
      <select class="pf-c-form-control" id="horizontal-form-title" name="horizontal-form-title">
        <option selected>Please choose</option>
        <option value="Mr">Mr</option>
        <option value="Miss">Miss</option>
        <option value="Mrs">Mrs</option>
        <option value="Ms">Ms</option>
        <option value="Dr">Dr</option>
        <option value="Other">Other</option>
      </select>
    </div>
  </div>
  <div class="pf-c-form__group">
    <div class="pf-c-form__group-label">
      <label class="pf-c-form__label" for="horizontal-form-exp">
        <span class="pf-c-form__label-text">Your experience</span>
      </label>
    </div>
    <div class="pf-c-form__group-control">
      <textarea class="pf-c-form-control" name="horizontal-form-exp" id="horizontal-form-exp"></textarea>
    </div>
  </div>
  <div class="pf-c-form__group">
    <div class="pf-c-form__group-control">
      <div class="pf-c-check">
        <input class="pf-c-check__input" type="checkbox" type="checkbox" id="alt-form-checkbox1" name="alt-form-checkbox1" />
        <label class="pf-c-check__label" for="alt-form-checkbox1">Follow up via email</label>
      </div>
    </div>
  </div>
  <div class="pf-c-form__group">
    <div class="pf-c-form__group-control">
      <div class="pf-c-check">
        <input class="pf-c-check__input" type="checkbox" type="checkbox" id="alt-form-checkbox2" name="alt-form-checkbox2" />
        <label class="pf-c-check__label" for="alt-form-checkbox2">Remember my password for 30 days</label>
      </div>
    </div>
  </div>
  <div class="pf-c-form__group pf-m-action">
    <div class="pf-c-form__group-control">
      <div class="pf-c-form__actions">
        <button class="pf-c-button pf-m-primary" type="submit">Submit form</button>
        <button class="pf-c-button pf-m-secondary" type="button">Cancel</button>
      </div>
    </div>
  </div>
</form>
```
