function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { storiesOf } from '@storybook/react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, number, text } from '@storybook/addon-knobs';
import TimePicker from '../TimePicker';
import TimePickerSelect from '../TimePickerSelect';
import SelectItem from '../SelectItem';
var props = {
  timepicker: function timepicker() {
    return {
      pattern: text('Regular expression for the value (pattern in <TimePicker>)', '(1[012]|[1-9]):[0-5][0-9](\\s)?(?i)'),
      placeholder: text('Placeholder text (placeholder in <TimePicker>)', 'hh:mm'),
      disabled: boolean('Disabled (disabled in <TimePicker>)', false),
      light: boolean('Light variant (light in <TimePicker>)', false),
      hideLabel: boolean('No label (hideLabel in <TimePicker>)', false),
      labelText: text('Label text (labelText in <TimePicker>)', 'Select a time'),
      invalid: boolean('Show form validation UI (invalid in <TimePicker>)', false),
      invalidText: text('Form validation UI content (invalidText in <TimePicker>)', 'A valid value is required'),
      maxLength: number('Maximum length (maxLength in <TimePicker>)', 5),
      onClick: action('onClick'),
      onChange: action('onChange'),
      onBlur: action('onBlur')
    };
  },
  select: function select() {
    return {
      disabled: boolean('Disabled (disabled in <TimePickerSelect>)', false),
      hideLabel: boolean('No label (hideLabel in <TimePickerSelect>)', true),
      labelText: text('Label text (labelText in <TimePickerSelect>)', 'Please select'),
      iconDescription: text('Trigger icon description (iconDescription in <TimePickerSelect>)', 'open list of options')
    };
  }
};
storiesOf('TimePicker', module).addDecorator(withKnobs).add('Default', function () {
  var selectProps = props.select();
  return React.createElement(TimePicker, _extends({
    id: "time-picker"
  }, props.timepicker()), React.createElement(TimePickerSelect, _extends({
    id: "time-picker-select-1"
  }, selectProps), React.createElement(SelectItem, {
    value: "AM",
    text: "AM"
  }), React.createElement(SelectItem, {
    value: "PM",
    text: "PM"
  })), React.createElement(TimePickerSelect, _extends({
    id: "time-picker-select-2"
  }, selectProps), React.createElement(SelectItem, {
    value: "Time zone 1",
    text: "Time zone 1"
  }), React.createElement(SelectItem, {
    value: "Time zone 2",
    text: "Time zone 2"
  })));
}, {
  info: {
    text: "\n            The time picker allow users to select a time.\n          "
  }
});