'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _downshift = require('downshift');

var _downshift2 = _interopRequireDefault(_downshift);

var _lodash = require('lodash.debounce');

var _lodash2 = _interopRequireDefault(_lodash);

var _lodash3 = require('lodash.isequal');

var _lodash4 = _interopRequireDefault(_lodash3);

var _ListBox = require('../ListBox');

var _ListBox2 = _interopRequireDefault(_ListBox);

var _Checkbox = require('../Checkbox');

var _Checkbox2 = _interopRequireDefault(_Checkbox);

var _GroupLabel = require('../GroupLabel');

var _GroupLabel2 = _interopRequireDefault(_GroupLabel);

var _Selection = require('../../internal/Selection');

var _Selection2 = _interopRequireDefault(_Selection);

var _MultiSelectPropTypes = require('./MultiSelectPropTypes');

var _itemToString = require('./tools/itemToString');

var _groupedByCategory = require('./tools/groupedByCategory');

var _sorting = require('./tools/sorting');

var _filter = require('./tools/filter');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var NestedFilterableMultiselect = function (_React$Component) {
  _inherits(NestedFilterableMultiselect, _React$Component);

  _createClass(NestedFilterableMultiselect, null, [{
    key: 'find',
    value: function find() {
      var items = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var target = arguments[1];

      var found = void 0;
      items.some(function (item) {
        if (item.id === target.id) {
          found = item;
          return true;
        }
        return false;
      });
      return found;
    }
  }, {
    key: 'computeId',
    value: function computeId(_ref) {
      var item = _ref.item,
          _ref$itemToString = _ref.itemToString,
          itemToString = _ref$itemToString === undefined ? _itemToString.defaultItemToString : _ref$itemToString,
          parentId = _ref.parentId;

      return '' + (parentId ? parentId + '-' : '') + (item.id || itemToString(item));
    }
  }, {
    key: 'flatten',
    value: function flatten(_ref2) {
      var category = _ref2.category,
          _ref2$items = _ref2.items,
          items = _ref2$items === undefined ? [] : _ref2$items,
          level = _ref2.level,
          parentId = _ref2.parentId,
          _ref2$itemToString = _ref2.itemToString,
          itemToString = _ref2$itemToString === undefined ? _itemToString.defaultItemToString : _ref2$itemToString;

      return items.reduce(function (list, item) {
        var mappedItem = _extends({}, item, {
          id: NestedFilterableMultiselect.computeId({
            item: item,
            itemToString: itemToString,
            parentId: parentId
          }),
          category: category || item.category,
          level: level || 0,
          hasChildren: !!item.options,
          parentId: parentId
        });
        list.push(mappedItem);
        if (Array.isArray(item.options) && item.options.length > 0) {
          list.push.apply(list, _toConsumableArray(NestedFilterableMultiselect.flatten({
            category: mappedItem.category,
            items: item.options,
            level: mappedItem.level + 1,
            parentId: mappedItem.id,
            itemToString: itemToString
          })));
        }
        return list;
      }, []);
    }
  }, {
    key: 'cleanItem',
    value: function cleanItem(item) {
      var result = _extends({}, item);
      delete result.options;
      delete result.checked;
      return result;
    }
  }, {
    key: 'getDerivedStateFromProps',
    value: function getDerivedStateFromProps(nextProps, currentState) {
      var items = nextProps.items,
          initialSelectedItems = nextProps.initialSelectedItems,
          itemToString = nextProps.itemToString;
      var flattenedItems = currentState.flattenedItems,
          flattenedSelectedItems = currentState.flattenedSelectedItems;


      var itemsToProcess = initialSelectedItems ? items.map(function (obj) {
        return initialSelectedItems.find(function (o) {
          return o.id === obj.id;
        }) || obj;
      }) : items;
      var isHierarchical = items.some(function (item) {
        return !!item.options;
      });
      var updatedItems = isHierarchical ? NestedFilterableMultiselect.flatten({
        items: itemsToProcess,
        itemToString: itemToString
      }).map(NestedFilterableMultiselect.cleanItem) : itemsToProcess;

      if (!(0, _lodash4.default)(updatedItems, flattenedItems)) {
        var updatedSelectedItems = isHierarchical ? NestedFilterableMultiselect.flatten({
          items: initialSelectedItems,
          itemToString: itemToString
        }).filter(function (item, index, itemArray) {
          if (!item.parentId || item.checked) {
            return true;
          }

          // Any parent checked will make all its children checked
          var hierarchy = (0, _sorting.buildHierarchy)(item, itemArray);
          var parentChecked = hierarchy.some(function (parent) {
            return parent.checked;
          });
          if (parentChecked) {
            return true;
          }

          // Any child checked will make its parent checked
          var allChildren = (0, _filter.getAllChildren)(item, itemArray);
          var childChecked = allChildren.some(function (child) {
            return child.checked;
          });
          if (childChecked) {
            return true;
          }

          // If none of the children has the `checked` flag,
          // all children are considered checked.
          var rootAllChildren = (0, _filter.getAllChildren)(hierarchy[0], itemArray);
          return rootAllChildren.length > 0 && !rootAllChildren.some(function (child) {
            return child.checked;
          });
        }).map(NestedFilterableMultiselect.cleanItem) : initialSelectedItems.reduce(function (list, item) {
          // Any parent checked will make all its children checked
          var hierarchy = (0, _sorting.buildHierarchy)(item, updatedItems);
          hierarchy.forEach(function (parent) {
            if (!NestedFilterableMultiselect.find(list, parent)) {
              list.push(_extends({}, parent));
            }
          });

          // If none of the children has the `checked` flag,
          // all children are considered checked.
          var allChildren = (0, _filter.getAllChildren)(item, updatedItems);
          if (!allChildren.some(function (child) {
            return NestedFilterableMultiselect.find(list, child);
          })) {
            list.push.apply(list, _toConsumableArray(allChildren.map(function (child) {
              return _extends({}, child);
            })));
          }

          return list;
        }, [].concat(_toConsumableArray(initialSelectedItems)));

        flattenedItems.splice.apply(flattenedItems, [0, flattenedItems.length].concat(_toConsumableArray(updatedItems)));
        flattenedSelectedItems.splice.apply(flattenedSelectedItems, [0, flattenedSelectedItems.length].concat(_toConsumableArray(updatedSelectedItems)));

        return _extends({}, currentState, {
          flattenedItems: flattenedItems,
          flattenedSelectedItems: flattenedSelectedItems
        });
      }

      return null;
    }
  }, {
    key: 'updateCheckedState',
    value: function updateCheckedState(_ref3) {
      var _ref3$options = _ref3.options,
          options = _ref3$options === undefined ? [] : _ref3$options,
          _ref3$itemToString = _ref3.itemToString,
          itemToString = _ref3$itemToString === undefined ? _itemToString.defaultItemToString : _ref3$itemToString,
          parentId = _ref3.parentId,
          selectedItems = _ref3.selectedItems;

      return options.map(function (option) {
        var optionId = NestedFilterableMultiselect.computeId({
          item: option,
          itemToString: itemToString,
          parentId: parentId
        });
        var result = _extends({}, option);
        if (result.options) {
          result.options = NestedFilterableMultiselect.updateCheckedState({
            options: result.options,
            itemToString: itemToString,
            parentId: optionId,
            selectedItems: selectedItems
          });
          // The parent is checked only if all its children is checked
          result.checked = !result.options.some(function (option) {
            return !option.checked;
          });
        } else {
          result.checked = selectedItems.some(function (selectedItem) {
            return selectedItem.id === optionId;
          });
        }
        return result;
      });
    }
  }]);

  function NestedFilterableMultiselect(props) {
    _classCallCheck(this, NestedFilterableMultiselect);

    var _this = _possibleConstructorReturn(this, (NestedFilterableMultiselect.__proto__ || Object.getPrototypeOf(NestedFilterableMultiselect)).call(this, props));

    _this.handleOnChange = function (changes) {
      var _this$props = _this.props,
          items = _this$props.items,
          itemToString = _this$props.itemToString,
          onChange = _this$props.onChange;


      if (onChange) {
        var _changes$selectedItem = changes.selectedItems,
            selectedItems = _changes$selectedItem === undefined ? [] : _changes$selectedItem;


        var isHierarchical = items.some(function (item) {
          return !!item.options;
        });
        var mappedSelectedItems = isHierarchical ? items.reduce(function (list, item) {
          if (NestedFilterableMultiselect.find(selectedItems, item)) {
            var selectedItem = _extends({}, item);
            if (item.options) {
              selectedItem.options = NestedFilterableMultiselect.updateCheckedState({
                options: item.options,
                itemToString: itemToString,
                parentId: NestedFilterableMultiselect.computeId({
                  item: item,
                  itemToString: itemToString
                }),
                selectedItems: selectedItems
              });
            }
            list.push(selectedItem);
          }
          return list;
        }, []) : selectedItems;

        onChange({ selectedItems: mappedSelectedItems });
      }
    };

    _this.onToggle = function (item) {
      var isExpanded = NestedFilterableMultiselect.find(_this.state.expandedItems, item);
      !isExpanded ? _this.setState({ expandedItems: [].concat(_toConsumableArray(_this.state.expandedItems), [item]) }) : _this.setState(function (prevState) {
        return {
          expandedItems: prevState.expandedItems.filter(function (expandedItem) {
            return expandedItem.id !== item.id;
          })
        };
      });
    };

    _this.handleOnOuterClick = function () {
      _this.setState({
        isOpen: false,
        inputValue: ''
      });
    };

    _this.handleOnStateChange = function (changes) {
      var type = changes.type;

      switch (type) {
        case _downshift2.default.stateChangeTypes.changeInput:
          _this.setState({
            inputValue: changes.inputValue,
            isOpen: true
          });
          break;
        case _downshift2.default.stateChangeTypes.keyDownArrowUp:
        case _downshift2.default.stateChangeTypes.itemMouseEnter:
          _this.setState({ highlightedIndex: changes.highlightedIndex });
          break;
        case _downshift2.default.stateChangeTypes.keyDownArrowDown:
          _this.setState({
            highlightedIndex: changes.highlightedIndex,
            isOpen: true
          });
          break;
        case _downshift2.default.stateChangeTypes.keyDownEscape:
        case _downshift2.default.stateChangeTypes.mouseUp:
          _this.setState({ isOpen: false });
          break;
        // Opt-in to some cases where we should be toggling the menu based on
        // a given key press or mouse handler
        // Reference: https://github.com/paypal/downshift/issues/206
        case _downshift2.default.stateChangeTypes.clickButton:
        case _downshift2.default.stateChangeTypes.keyDownSpaceButton:
          _this.setState(function () {
            var nextIsOpen = changes.isOpen || false;
            if (!changes.isOpen) {
              // If Downshift is trying to close the menu, but we know the input
              // is the active element in thedocument, then keep the menu open
              if (_this.inputNode === document.activeElement) {
                nextIsOpen = true;
              }
            }
            return {
              isOpen: nextIsOpen
            };
          });
          break;
      }
    };

    _this.handleOnInputValueChange = (0, _lodash2.default)(function (value, _ref4) {
      var type = _ref4.type;

      if (type === _downshift2.default.stateChangeTypes.changeInput) {
        var _this$props2 = _this.props,
            filterItems = _this$props2.filterItems,
            itemToString = _this$props2.itemToString;
        var _this$state = _this.state,
            expandedItems = _this$state.expandedItems,
            items = _this$state.flattenedItems,
            prevInputValue = _this$state.inputValue;


        var inputValue = Array.isArray(value) ? prevInputValue : value;

        var itemsToExpand = items.reduce(function (toExpand, item) {
          var allChildren = (0, _filter.getAllChildren)(item, items);
          if (allChildren.length > 0) {
            var filteredChildren = filterItems(allChildren, {
              itemToString: itemToString,
              inputValue: inputValue
            });
            if (filteredChildren.length > 0) {
              if (!inputValue || NestedFilterableMultiselect.find(expandedItems, item)) {
                return toExpand;
              }
              if (!NestedFilterableMultiselect.find(toExpand, item)) {
                toExpand.push(item);
              }
            }
          }
          return toExpand;
        }, []);

        _this.setState(function () {
          return {
            expandedItems: [].concat(_toConsumableArray(expandedItems), _toConsumableArray(itemsToExpand)),
            inputValue: inputValue || ''
          };
        });
      }
    }, 200).bind(_this);

    _this.clearInputValue = function (event) {
      event.stopPropagation();
      _this.setState({ inputValue: '' });
      _this.inputNode && _this.inputNode.focus && _this.inputNode.focus();
    };

    _this.getParentItem = function (item) {
      var items = _this.state.flattenedItems;

      return (0, _sorting.findParent)(item, items);
    };

    _this.onItemChange = function (item, selectedItems, onItemChange) {
      var items = _this.state.flattenedItems;


      var toRemove = !!NestedFilterableMultiselect.find(selectedItems, item);

      var itemsChanged = [item];

      if (item.parentId) {
        // Walk parents
        var parents = (0, _sorting.buildHierarchy)(item, items).reverse();
        parents.shift();
        parents.some(function (parent) {
          var isSelected = !!NestedFilterableMultiselect.find(selectedItems, parent);
          var children = selectedItems.filter(function (selectedItem) {
            return selectedItem.parentId === parent.id;
          });
          if (children.length === 1 && toRemove && isSelected) {
            // Uncheck parent too and keep walking up
            itemsChanged.push(parent);
            return false;
          } else if (!toRemove && !isSelected) {
            // Check parent too
            itemsChanged.push(parent);
            return false;
          }
          // If selecting a new item, we need to keep going up to
          // make sure all parents are checked.
          // If unselecting an item, we will break out when the
          // current parent does not need to be removed
          return toRemove;
        });
      }

      // Walk children
      var children = (0, _filter.getAllChildren)(item, items);
      if (children.length > 0) {
        children.forEach(function (child) {
          var isSelected = !!NestedFilterableMultiselect.find(selectedItems, child);
          if (toRemove && isSelected) {
            // Uncheck the child too
            itemsChanged.push(child);
          } else if (!toRemove && !isSelected) {
            // Check the child too
            itemsChanged.push(child);
          }
        });
      }

      onItemChange(itemsChanged);
    };

    _this.state = {
      highlightedIndex: null,
      isOpen: false,
      inputValue: '',
      flattenedItems: [],
      flattenedSelectedItems: [],
      expandedItems: []
    };
    return _this;
  }

  _createClass(NestedFilterableMultiselect, [{
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _state = this.state,
          highlightedIndex = _state.highlightedIndex,
          isOpen = _state.isOpen,
          inputValue = _state.inputValue,
          expandedItems = _state.expandedItems,
          items = _state.flattenedItems,
          initialSelectedItems = _state.flattenedSelectedItems;
      var _props = this.props,
          containerClassName = _props.className,
          disabled = _props.disabled,
          filterItems = _props.filterItems,
          itemToString = _props.itemToString,
          id = _props.id,
          locale = _props.locale,
          placeholder = _props.placeholder,
          sortItems = _props.sortItems,
          compareItems = _props.compareItems,
          light = _props.light,
          customCategorySorting = _props.customCategorySorting,
          showTooltip = _props.showTooltip;


      var className = (0, _classnames2.default)('bx--multi-select', 'bx--combo-box', containerClassName, {
        'bx--list-box--light': light
      });

      var currentIndex = -1;
      var highlighted = void 0;

      return _react2.default.createElement(_Selection2.default, {
        onChange: this.handleOnChange,
        initialSelectedItems: initialSelectedItems,
        render: function render(_ref5) {
          var selectedItems = _ref5.selectedItems,
              onItemChange = _ref5.onItemChange,
              clearSelection = _ref5.clearSelection;
          return _react2.default.createElement(_downshift2.default, {
            highlightedIndex: highlightedIndex,
            isOpen: isOpen,
            inputValue: inputValue,
            onInputValueChange: _this2.handleOnInputValueChange,
            onChange: function onChange(item) {
              _this2.onItemChange(item, selectedItems, onItemChange);
            },
            itemToString: itemToString,
            onStateChange: _this2.handleOnStateChange,
            onOuterClick: _this2.handleOnOuterClick,
            selectedItem: selectedItems,
            render: function render(_ref6) {
              var getButtonProps = _ref6.getButtonProps,
                  getInputProps = _ref6.getInputProps,
                  getItemProps = _ref6.getItemProps,
                  getRootProps = _ref6.getRootProps,
                  isOpen = _ref6.isOpen,
                  inputValue = _ref6.inputValue,
                  selectedItem = _ref6.selectedItem;
              return _react2.default.createElement(
                _ListBox2.default,
                _extends({
                  className: className,
                  disabled: disabled
                }, getRootProps({ refKey: 'innerRef' })),
                _react2.default.createElement(
                  _ListBox2.default.Field,
                  _extends({ tabIndex: '-1' }, getButtonProps({ disabled: disabled })),
                  selectedItem.length > 0 && _react2.default.createElement(_ListBox2.default.Selection, {
                    clearSelection: clearSelection,
                    selectionCount: selectedItem.filter(function (item) {
                      return !item.hasChildren;
                    }).length
                  }),
                  _react2.default.createElement('input', _extends({
                    className: 'bx--text-input',
                    'aria-label': placeholder,
                    ref: function ref(el) {
                      return _this2.inputNode = el;
                    }
                  }, getInputProps({
                    disabled: disabled,
                    id: id,
                    placeholder: placeholder,
                    onKeyDown: function onKeyDown(e) {
                      e.stopPropagation();
                      var highlightedItem = highlighted && highlighted.item;
                      if (highlightedItem) {
                        if (e.which === 40) {
                          // Down arrow
                          if (highlightedItem.hasChildren && !expandedItems.includes(highlightedItem)) {
                            _this2.onToggle(highlightedItem);
                          }
                        } else if (e.which === 38) {
                          // Up arrow
                          var parentItem = _this2.getParentItem(highlightedItem);
                          if (parentItem && highlighted.parentIndex > -1 && highlighted.index === highlighted.parentIndex + 1 && expandedItems.includes(parentItem)) {
                            _this2.onToggle(parentItem);
                          }
                        }
                      }
                    },
                    onKeyUp: function onKeyUp(e) {
                      var which = e.which;
                      if (which === 27) {
                        _this2.setState({ isOpen: false });
                      }
                    }
                  }))),
                  inputValue && isOpen && _react2.default.createElement(_ListBox2.default.Selection, { clearSelection: _this2.clearInputValue }),
                  _react2.default.createElement(_ListBox2.default.MenuIcon, { isOpen: isOpen })
                ),
                isOpen && _react2.default.createElement(
                  _ListBox2.default.Menu,
                  {
                    style: {
                      maxHeight: '424px',
                      overflowX: 'hidden',
                      paddingTop: '8px'
                    } },
                  (0, _groupedByCategory.groupedByCategory)(items, customCategorySorting).map(function (group, index) {
                    var hasGroups = group[0] !== 'undefined' ? true : false;
                    var filteredItems = filterItems(group[1], {
                      itemToString: itemToString,
                      inputValue: inputValue,
                      expandedItems: expandedItems
                    });
                    var categoryName = '';
                    hasGroups ? categoryName = group[0].toUpperCase() : null;

                    return _react2.default.createElement(
                      _react.Fragment,
                      { key: group[0] || index },
                      hasGroups && filteredItems.length > 0 && _react2.default.createElement(
                        'div',
                        null,
                        _react2.default.createElement(
                          _GroupLabel2.default,
                          { key: index },
                          categoryName
                        )
                      ),
                      sortItems(filteredItems, {
                        selectedItems: selectedItems,
                        itemToString: itemToString,
                        compareItems: compareItems,
                        locale: locale
                      }).map(function (item, itemIndex, itemArr) {
                        currentIndex++;

                        if (highlightedIndex === currentIndex) {
                          var parentItem = _this2.getParentItem(item);
                          highlighted = {
                            item: item,
                            index: itemIndex,
                            parentIndex: parentItem ? itemArr.indexOf(parentItem) : -1
                          };
                        }

                        var itemProps = getItemProps({
                          item: item,
                          index: currentIndex
                        });
                        var itemText = itemToString(item);

                        var isChecked = selectedItem.filter(function (selected) {
                          return selected.id == item.id;
                        }).length > 0;
                        var subOptions = (0, _filter.getAllChildren)(item, items);
                        var groupIsOpen = !!NestedFilterableMultiselect.find(expandedItems, item);

                        var myCheckedOptions = subOptions.filter(function (subOption) {
                          return selectedItem.filter(function (selected) {
                            return selected.id === subOption.id;
                          }).length > 0;
                        });
                        var myUncheckedOptions = subOptions.filter(function (subOption) {
                          return selectedItem.filter(function (selected) {
                            return selected.id === subOption.id;
                          }).length === 0;
                        });

                        var itemStyle = item.level ? {
                          paddingLeft: item.level * 19 + 16 + 'px'
                        } : undefined;

                        return _react2.default.createElement(
                          _ListBox2.default.MenuItem,
                          _extends({
                            style: itemStyle,
                            isActive: isChecked,
                            isHighlighted: highlightedIndex === currentIndex
                          }, itemProps, {
                            onClick: function onClick(e) {
                              {
                                var clickOutOfCheckBox = subOptions.length > 0 && e.target.localName !== 'label' && e.target.localName !== 'input';
                                if (clickOutOfCheckBox) {
                                  _this2.onToggle(item);
                                } else {
                                  _this2.onItemChange(item, selectedItems, onItemChange);
                                }
                              }
                            } }),
                          _react2.default.createElement(_Checkbox2.default, {
                            id: 'cb-' + itemProps.id,
                            name: itemText,
                            checked: isChecked,
                            indeterminate: myCheckedOptions && myUncheckedOptions && myCheckedOptions.length > 0 && myUncheckedOptions.length > 0,
                            readOnly: true,
                            tabIndex: '-1',
                            labelText: itemText,
                            tooltipText: showTooltip && itemText,
                            hasGroups: subOptions.length > 0,
                            isExpanded: groupIsOpen
                          })
                        );
                      })
                    );
                  })
                )
              );
            }
          });
        }
      });
    }
  }]);

  return NestedFilterableMultiselect;
}(_react2.default.Component);

NestedFilterableMultiselect.propTypes = _extends({}, _MultiSelectPropTypes.sortingPropTypes, {

  /**
   * Disable the control
   */
  disabled: _propTypes2.default.bool,

  /**
   * We try to stay as generic as possible here to allow individuals to pass
   * in a collection of whatever kind of data structure they prefer
   */
  items: _propTypes2.default.array.isRequired,

  /**
   * Allow users to pass in arbitrary items from their collection that are
   * pre-selected
   */
  initialSelectedItems: _propTypes2.default.array,

  /**
   * Helper function passed to downshift that allows the library to render a
   * given item to a string label. By default, it extracts the `label` field
   * from a given item to serve as the item label in the list.
   */
  itemToString: _propTypes2.default.func,

  /**
   * Specify the locale of the control. Used for the default `compareItems`
   * used for sorting the list of items in the control.
   */
  locale: _propTypes2.default.string,

  /**
   * `onChange` is a utility for this controlled component to communicate to a
   * consuming component what kind of internal state changes are occuring.
   */
  onChange: _propTypes2.default.func,

  /**
   * Generic `placeholder` that will be used as the textual representation of
   * what this field is for
   */
  placeholder: _propTypes2.default.string.isRequired,

  /**
   * `true` to use the light version.
   */
  light: _propTypes2.default.bool,

  /**
   * `customCategorySorting` is use to sort the items by category, aphabetic order if not specify
   */
  customCategorySorting: _propTypes2.default.func,

  /**
   * `true` to show tooltip.
   */
  showTooltip: _propTypes2.default.bool
});
NestedFilterableMultiselect.defaultProps = {
  compareItems: _sorting.defaultCompareItems,
  disabled: false,
  filterItems: _filter.defaultFilterItems,
  initialSelectedItems: [],
  itemToString: _itemToString.defaultItemToString,
  locale: 'en',
  sortItems: _sorting.defaultSortItems,
  light: false,
  showTooltip: true
};
exports.default = NestedFilterableMultiselect;