import { __rest } from "tslib";
import * as React from 'react';
import styles from '@patternfly/react-styles/css/components/SearchInput/search-input';
import { css } from '@patternfly/react-styles';
import { Button, ButtonVariant } from '../Button';
import { Badge } from '../Badge';
import AngleDownIcon from "@patternfly/react-icons/dist/esm/icons/angle-down-icon";
import AngleUpIcon from "@patternfly/react-icons/dist/esm/icons/angle-up-icon";
import TimesIcon from "@patternfly/react-icons/dist/esm/icons/times-icon";
import SearchIcon from "@patternfly/react-icons/dist/esm/icons/search-icon";
export const SearchInput = (_a) => {
    var { className, value = '', placeholder, onChange, onClear, resultsCount, onNextClick, onPreviousClick, 'aria-label': ariaLabel = 'Search input' } = _a, props = __rest(_a, ["className", "value", "placeholder", "onChange", "onClear", "resultsCount", "onNextClick", "onPreviousClick", 'aria-label']);
    const onChangeHandler = (event) => {
        if (onChange) {
            onChange(event.currentTarget.value, event);
        }
    };
    return (React.createElement("div", Object.assign({ className: css(className, styles.searchInput) }, props),
        React.createElement("span", { className: css(styles.searchInputText) },
            React.createElement("span", { className: css(styles.searchInputIcon) },
                React.createElement(SearchIcon, null)),
            React.createElement("input", { className: css(styles.searchInputTextInput), value: value, placeholder: placeholder, "aria-label": ariaLabel, onChange: onChangeHandler })),
        value && (React.createElement("span", { className: css(styles.searchInputUtilities) },
            resultsCount && (React.createElement("span", { className: css(styles.searchInputCount) },
                React.createElement(Badge, { isRead: true }, resultsCount))),
            !!onNextClick && !!onPreviousClick && (React.createElement("span", { className: css(styles.searchInputNav) },
                React.createElement(Button, { variant: ButtonVariant.plain, "aria-label": "Previous", onClick: onPreviousClick },
                    React.createElement(AngleUpIcon, null)),
                React.createElement(Button, { variant: ButtonVariant.plain, "aria-label": "Next", onClick: onNextClick },
                    React.createElement(AngleDownIcon, null)))),
            React.createElement("span", { className: "pf-c-search-input__clear" },
                React.createElement(Button, { variant: ButtonVariant.plain, "aria-label": "Clear", onClick: onClear },
                    React.createElement(TimesIcon, null)))))));
};
SearchInput.displayName = 'SearchInput';
//# sourceMappingURL=SearchInput.js.map