"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapNativeEventNames = mapNativeEventNames;
exports.propFromEvent = propFromEvent;
exports.withSetStateAllowed = withSetStateAllowed;
exports.assertDomAvailable = assertDomAvailable;
exports.displayNameOfNode = displayNameOfNode;
exports.nodeTypeFromType = nodeTypeFromType;
exports.isArrayLike = isArrayLike;
exports.flatten = flatten;
exports.ensureKeyOrUndefined = ensureKeyOrUndefined;
exports.elementToTree = elementToTree;
exports.findElement = findElement;
exports.propsWithKeysAndRef = propsWithKeysAndRef;
exports.getComponentStack = getComponentStack;
exports.simulateError = simulateError;
exports.getMaskedContext = getMaskedContext;
exports.getNodeFromRootFinder = getNodeFromRootFinder;
exports.wrapWithWrappingComponent = wrapWithWrappingComponent;
exports.getWrappingComponentMountRenderer = getWrappingComponentMountRenderer;
exports.fakeDynamicImport = fakeDynamicImport;
exports.compareNodeTypeOf = compareNodeTypeOf;
Object.defineProperty(exports, "createMountWrapper", {
  enumerable: true,
  get: function get() {
    return _createMountWrapper["default"];
  }
});
Object.defineProperty(exports, "createRenderWrapper", {
  enumerable: true,
  get: function get() {
    return _createRenderWrapper["default"];
  }
});
Object.defineProperty(exports, "wrap", {
  enumerable: true,
  get: function get() {
    return _wrapWithSimpleWrapper["default"];
  }
});
Object.defineProperty(exports, "RootFinder", {
  enumerable: true,
  get: function get() {
    return _RootFinder["default"];
  }
});

var _functionPrototype = _interopRequireDefault(require("function.prototype.name"));

var _object = _interopRequireDefault(require("object.fromentries"));

var _createMountWrapper = _interopRequireDefault(require("./createMountWrapper"));

var _createRenderWrapper = _interopRequireDefault(require("./createRenderWrapper"));

var _wrapWithSimpleWrapper = _interopRequireDefault(require("./wrapWithSimpleWrapper"));

var _RootFinder = _interopRequireDefault(require("./RootFinder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function mapNativeEventNames(event) {
  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      _ref$animation = _ref.animation,
      animation = _ref$animation === void 0 ? false : _ref$animation,
      _ref$pointerEvents = _ref.pointerEvents,
      pointerEvents = _ref$pointerEvents === void 0 ? false : _ref$pointerEvents,
      _ref$auxClick = _ref.auxClick,
      auxClick = _ref$auxClick === void 0 ? false : _ref$auxClick;

  var nativeToReactEventMap = _objectSpread(_objectSpread(_objectSpread({
    compositionend: 'compositionEnd',
    compositionstart: 'compositionStart',
    compositionupdate: 'compositionUpdate',
    keydown: 'keyDown',
    keyup: 'keyUp',
    keypress: 'keyPress',
    contextmenu: 'contextMenu',
    dblclick: 'doubleClick',
    doubleclick: 'doubleClick',
    // kept for legacy. TODO: remove with next major.
    dragend: 'dragEnd',
    dragenter: 'dragEnter',
    dragexist: 'dragExit',
    dragleave: 'dragLeave',
    dragover: 'dragOver',
    dragstart: 'dragStart',
    mousedown: 'mouseDown',
    mousemove: 'mouseMove',
    mouseout: 'mouseOut',
    mouseover: 'mouseOver',
    mouseup: 'mouseUp',
    touchcancel: 'touchCancel',
    touchend: 'touchEnd',
    touchmove: 'touchMove',
    touchstart: 'touchStart',
    canplay: 'canPlay',
    canplaythrough: 'canPlayThrough',
    durationchange: 'durationChange',
    loadeddata: 'loadedData',
    loadedmetadata: 'loadedMetadata',
    loadstart: 'loadStart',
    ratechange: 'rateChange',
    timeupdate: 'timeUpdate',
    volumechange: 'volumeChange',
    beforeinput: 'beforeInput',
    mouseenter: 'mouseEnter',
    mouseleave: 'mouseLeave',
    transitionend: 'transitionEnd'
  }, animation && {
    animationstart: 'animationStart',
    animationiteration: 'animationIteration',
    animationend: 'animationEnd'
  }), pointerEvents && {
    pointerdown: 'pointerDown',
    pointermove: 'pointerMove',
    pointerup: 'pointerUp',
    pointercancel: 'pointerCancel',
    gotpointercapture: 'gotPointerCapture',
    lostpointercapture: 'lostPointerCapture',
    pointerenter: 'pointerEnter',
    pointerleave: 'pointerLeave',
    pointerover: 'pointerOver',
    pointerout: 'pointerOut'
  }), auxClick && {
    auxclick: 'auxClick'
  });

  return nativeToReactEventMap[event] || event;
} // 'click' => 'onClick'
// 'mouseEnter' => 'onMouseEnter'


function propFromEvent(event) {
  var eventOptions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var nativeEvent = mapNativeEventNames(event, eventOptions);
  return "on".concat(nativeEvent[0].toUpperCase()).concat(nativeEvent.slice(1));
}

function withSetStateAllowed(fn) {
  // NOTE(lmr):
  // this is currently here to circumvent a React bug where `setState()` is
  // not allowed without global being defined.
  var cleanup = false;

  if (typeof global.document === 'undefined') {
    cleanup = true;
    global.document = {};
  }

  var result = fn();

  if (cleanup) {
    // This works around a bug in node/jest in that developers aren't able to
    // delete things from global when running in a node vm.
    global.document = undefined;
    delete global.document;
  }

  return result;
}

function assertDomAvailable(feature) {
  if (!global || !global.document || !global.document.createElement) {
    throw new Error("Enzyme's ".concat(feature, " expects a DOM environment to be loaded, but found none"));
  }
}

function displayNameOfNode(node) {
  if (!node) return null;
  var type = node.type;
  if (!type) return null;
  return type.displayName || (typeof type === 'function' ? (0, _functionPrototype["default"])(type) : type.name || type);
}

function nodeTypeFromType(type) {
  if (typeof type === 'string') {
    return 'host';
  }

  if (type && type.prototype && type.prototype.isReactComponent) {
    return 'class';
  }

  return 'function';
}

function getIteratorFn(obj) {
  var iteratorFn = obj && (typeof Symbol === 'function' && _typeof(Symbol.iterator) === 'symbol' && obj[Symbol.iterator] || obj['@@iterator']);

  if (typeof iteratorFn === 'function') {
    return iteratorFn;
  }

  return undefined;
}

function isIterable(obj) {
  return !!getIteratorFn(obj);
}

function isArrayLike(obj) {
  return Array.isArray(obj) || typeof obj !== 'string' && isIterable(obj);
}

function flatten(arrs) {
  // optimize for the most common case
  if (Array.isArray(arrs)) {
    return arrs.reduce(function (flatArrs, item) {
      return flatArrs.concat(isArrayLike(item) ? flatten(item) : item);
    }, []);
  } // fallback for arbitrary iterable children


  var flatArrs = [];
  var iteratorFn = getIteratorFn(arrs);
  var iterator = iteratorFn.call(arrs);
  var step = iterator.next();

  while (!step.done) {
    var item = step.value;
    var flatItem = void 0;

    if (isArrayLike(item)) {
      flatItem = flatten(item);
    } else {
      flatItem = item;
    }

    flatArrs = flatArrs.concat(flatItem);
    step = iterator.next();
  }

  return flatArrs;
}

function ensureKeyOrUndefined(key) {
  return key || (key === '' ? '' : undefined);
}

function elementToTree(el) {
  var recurse = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : elementToTree;

  if (typeof recurse !== 'function' && arguments.length === 3) {
    // special case for backwards compat for `.map(elementToTree)`
    recurse = elementToTree; // eslint-disable-line no-param-reassign
  }

  if (el === null || _typeof(el) !== 'object' || !('type' in el)) {
    return el;
  }

  var type = el.type,
      props = el.props,
      key = el.key,
      ref = el.ref;
  var children = props.children;
  var rendered = null;

  if (isArrayLike(children)) {
    rendered = flatten(children).map(function (x) {
      return recurse(x);
    });
  } else if (typeof children !== 'undefined') {
    rendered = recurse(children);
  }

  var nodeType = nodeTypeFromType(type);

  if (nodeType === 'host' && props.dangerouslySetInnerHTML) {
    if (props.children != null) {
      var error = new Error('Can only set one of `children` or `props.dangerouslySetInnerHTML`.');
      error.name = 'Invariant Violation';
      throw error;
    }
  }

  return {
    nodeType: nodeType,
    type: type,
    props: props,
    key: ensureKeyOrUndefined(key),
    ref: ref,
    instance: null,
    rendered: rendered
  };
}

function mapFind(arraylike, mapper, finder) {
  var found;
  var isFound = Array.prototype.find.call(arraylike, function (item) {
    found = mapper(item);
    return finder(found);
  });
  return isFound ? found : undefined;
}

function findElement(el, predicate) {
  if (el === null || _typeof(el) !== 'object' || !('type' in el)) {
    return undefined;
  }

  if (predicate(el)) {
    return el;
  }

  var rendered = el.rendered;

  if (isArrayLike(rendered)) {
    return mapFind(rendered, function (x) {
      return findElement(x, predicate);
    }, function (x) {
      return typeof x !== 'undefined';
    });
  }

  return findElement(rendered, predicate);
}

function propsWithKeysAndRef(node) {
  if (node.ref !== null || node.key !== null) {
    return _objectSpread(_objectSpread({}, node.props), {}, {
      key: node.key,
      ref: node.ref
    });
  }

  return node.props;
}

function getComponentStack(hierarchy) {
  var getNodeType = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : nodeTypeFromType;
  var getDisplayName = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : displayNameOfNode;
  var tuples = hierarchy.filter(function (node) {
    return node.type !== _RootFinder["default"];
  }).map(function (x) {
    return [getNodeType(x.type), getDisplayName(x)];
  }).concat([['class', 'WrapperComponent']]);
  return tuples.map(function (_ref2, i, arr) {
    var _ref3 = _slicedToArray(_ref2, 2),
        name = _ref3[1];

    var _ref4 = arr.slice(i + 1).find(function (_ref6) {
      var _ref7 = _slicedToArray(_ref6, 1),
          nodeType = _ref7[0];

      return nodeType !== 'host';
    }) || [],
        _ref5 = _slicedToArray(_ref4, 2),
        closestComponent = _ref5[1];

    return "\n    in ".concat(name).concat(closestComponent ? " (created by ".concat(closestComponent, ")") : '');
  }).join('');
}

function simulateError(error, catchingInstance, rootNode, // TODO: remove `rootNode` next semver-major
hierarchy) {
  var getNodeType = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : nodeTypeFromType;
  var getDisplayName = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : displayNameOfNode;
  var catchingType = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : {};
  var instance = catchingInstance || {};
  var componentDidCatch = instance.componentDidCatch;
  var getDerivedStateFromError = catchingType.getDerivedStateFromError;

  if (!componentDidCatch && !getDerivedStateFromError) {
    throw error;
  }

  if (getDerivedStateFromError) {
    var stateUpdate = getDerivedStateFromError.call(catchingType, error);
    instance.setState(stateUpdate);
  }

  if (componentDidCatch) {
    var componentStack = getComponentStack(hierarchy, getNodeType, getDisplayName);
    componentDidCatch.call(instance, error, {
      componentStack: componentStack
    });
  }
}

function getMaskedContext(contextTypes, unmaskedContext) {
  if (!contextTypes || !unmaskedContext) {
    return {};
  }

  return (0, _object["default"])(Object.keys(contextTypes).map(function (key) {
    return [key, unmaskedContext[key]];
  }));
}

function getNodeFromRootFinder(isCustomComponent, tree, options) {
  if (!isCustomComponent(options.wrappingComponent)) {
    return tree.rendered;
  }

  var rootFinder = findElement(tree, function (node) {
    return node.type === _RootFinder["default"];
  });

  if (!rootFinder) {
    throw new Error('`wrappingComponent` must render its children!');
  }

  return rootFinder.rendered;
}

function wrapWithWrappingComponent(createElement, node, options) {
  var wrappingComponent = options.wrappingComponent,
      wrappingComponentProps = options.wrappingComponentProps;

  if (!wrappingComponent) {
    return node;
  }

  return createElement(wrappingComponent, wrappingComponentProps, createElement(_RootFinder["default"], null, node));
}

function getWrappingComponentMountRenderer(_ref8) {
  var toTree = _ref8.toTree,
      getMountWrapperInstance = _ref8.getMountWrapperInstance;
  return {
    getNode: function getNode() {
      var instance = getMountWrapperInstance();
      return instance ? toTree(instance).rendered : null;
    },
    render: function render(el, context, callback) {
      var instance = getMountWrapperInstance();

      if (!instance) {
        throw new Error('The wrapping component may not be updated if the root is unmounted.');
      }

      return instance.setWrappingComponentProps(el.props, callback);
    }
  };
}

function fakeDynamicImport(moduleToImport) {
  return Promise.resolve({
    "default": moduleToImport
  });
}

function compareNodeTypeOf(node, matchingTypeOf) {
  if (!node) {
    return false;
  }

  return node.$$typeof === matchingTypeOf;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//# sourceMappingURL=Utils.js.map