---
id: Touchspin
section: components
cssPrefix: pf-c-touchspin
beta: true
---## Examples

### Default

```html
<div class="pf-c-touchspin">
  <div class="pf-c-input-group">
    <button class="pf-c-button pf-m-control" type="button" aria-label="Minus">
      <span class="pf-c-touchspin__icon">
        <i class="fas fa-minus" aria-hidden="true"></i>
      </span>
    </button>
    <input class="pf-c-form-control" type="text" value="90" name="textInput1" aria-label="Input touchspin" />
    <button class="pf-c-button pf-m-control" type="button" aria-label="Plus">
      <span class="pf-c-touchspin__icon">
        <i class="fas fa-plus" aria-hidden="true"></i>
      </span>
    </button>
  </div>
</div>
```

### With unit

```html
<div class="pf-c-touchspin">
  <div class="pf-c-input-group">
    <button class="pf-c-button pf-m-control" type="button" aria-label="Minus">
      <span class="pf-c-touchspin__icon">
        <i class="fas fa-minus" aria-hidden="true"></i>
      </span>
    </button>
    <input class="pf-c-form-control" type="text" value="90" name="textInput3" aria-label="Input touchspin" />
    <button class="pf-c-button pf-m-control" type="button" aria-label="Plus">
      <span class="pf-c-touchspin__icon">
        <i class="fas fa-plus" aria-hidden="true"></i>
      </span>
    </button>
  </div>
  <div class="pf-c-touchspin__unit">%</div>
</div>
<br />
<br />
<div class="pf-c-touchspin">
  <div class="pf-c-touchspin__unit">$</div>
  <div class="pf-c-input-group">
    <button class="pf-c-button pf-m-control" type="button" aria-label="Minus">
      <span class="pf-c-touchspin__icon">
        <i class="fas fa-minus" aria-hidden="true"></i>
      </span>
    </button>
    <input class="pf-c-form-control" type="text" value="1.00" name="textInput5" aria-label="Input touchspin" />
    <button class="pf-c-button pf-m-control" type="button" aria-label="Plus">
      <span class="pf-c-touchspin__icon">
        <i class="fas fa-plus" aria-hidden="true"></i>
      </span>
    </button>
  </div>
</div>
```

### With unit and lower threshold reached

```html
<div class="pf-c-touchspin">
  <div class="pf-c-input-group">
    <button class="pf-c-button pf-m-control" type="button" aria-label="Minus" disabled>
      <span class="pf-c-touchspin__icon">
        <i class="fas fa-minus" aria-hidden="true"></i>
      </span>
    </button>
    <input class="pf-c-form-control" type="text" value="0" name="textInput7" aria-label="Input touchspin" />
    <button class="pf-c-button pf-m-control" type="button" aria-label="Plus">
      <span class="pf-c-touchspin__icon">
        <i class="fas fa-plus" aria-hidden="true"></i>
      </span>
    </button>
  </div>
  <div class="pf-c-touchspin__unit">%</div>
</div>
```

### With unit and upper threshold reached

```html
<div class="pf-c-touchspin">
  <div class="pf-c-input-group">
    <button class="pf-c-button pf-m-control" type="button" aria-label="Minus">
      <span class="pf-c-touchspin__icon">
        <i class="fas fa-minus" aria-hidden="true"></i>
      </span>
    </button>
    <input class="pf-c-form-control" type="text" value="100" name="textInput9" aria-label="Input touchspin" />
    <button class="pf-c-button pf-m-control" type="button" aria-label="Plus" disabled>
      <span class="pf-c-touchspin__icon">
        <i class="fas fa-plus" aria-hidden="true"></i>
      </span>
    </button>
  </div>
  <div class="pf-c-touchspin__unit">%</div>
</div>
```

### Disabled

```html
<div class="pf-c-touchspin">
  <div class="pf-c-input-group">
    <button class="pf-c-button pf-m-control" type="button" aria-label="Minus" disabled>
      <span class="pf-c-touchspin__icon">
        <i class="fas fa-minus" aria-hidden="true"></i>
      </span>
    </button>
    <input class="pf-c-form-control" type="text" value="100" name="textInput9" aria-label="Input touchspin" disabled />
    <button class="pf-c-button pf-m-control" type="button" aria-label="Plus" disabled>
      <span class="pf-c-touchspin__icon">
        <i class="fas fa-plus" aria-hidden="true"></i>
      </span>
    </button>
  </div>
  <div class="pf-c-touchspin__unit">%</div>
</div>
```

### Varying sizes

```html
<div class="pf-c-touchspin" style="--pf-c-touchspin--c-form-control--width-chars: 1;">
  <div class="pf-c-input-group">
    <button class="pf-c-button pf-m-control" type="button" aria-label="Minus">
      <span class="pf-c-touchspin__icon">
        <i class="fas fa-minus" aria-hidden="true"></i>
      </span>
    </button>
    <input class="pf-c-form-control" type="text" value="1" name="textInput1" aria-label="Input touchspin" />
    <button class="pf-c-button pf-m-control" type="button" aria-label="Plus">
      <span class="pf-c-touchspin__icon">
        <i class="fas fa-plus" aria-hidden="true"></i>
      </span>
    </button>
  </div>
</div>
<br />
<br />
<div class="pf-c-touchspin" style="--pf-c-touchspin--c-form-control--width-chars: 10;">
  <div class="pf-c-input-group">
    <button class="pf-c-button pf-m-control" type="button" aria-label="Minus">
      <span class="pf-c-touchspin__icon">
        <i class="fas fa-minus" aria-hidden="true"></i>
      </span>
    </button>
    <input class="pf-c-form-control" type="text" value="1234567890" name="textInput1" aria-label="Input touchspin" />
    <button class="pf-c-button pf-m-control" type="button" aria-label="Plus">
      <span class="pf-c-touchspin__icon">
        <i class="fas fa-plus" aria-hidden="true"></i>
      </span>
    </button>
  </div>
</div>
<br />
<br />
<div class="pf-c-touchspin" style="--pf-c-touchspin--c-form-control--width-chars: 5;">
  <div class="pf-c-input-group">
    <button class="pf-c-button pf-m-control" type="button" aria-label="Minus">
      <span class="pf-c-touchspin__icon">
        <i class="fas fa-minus" aria-hidden="true"></i>
      </span>
    </button>
    <input class="pf-c-form-control" type="text" value="5" name="textInput1" aria-label="Input touchspin" />
    <button class="pf-c-button pf-m-control" type="button" aria-label="Plus">
      <span class="pf-c-touchspin__icon">
        <i class="fas fa-plus" aria-hidden="true"></i>
      </span>
    </button>
  </div>
</div>
<br />
<br />
<div class="pf-c-touchspin" style="--pf-c-touchspin--c-form-control--width-chars: 5;">
  <div class="pf-c-input-group">
    <button class="pf-c-button pf-m-control" type="button" aria-label="Minus">
      <span class="pf-c-touchspin__icon">
        <i class="fas fa-minus" aria-hidden="true"></i>
      </span>
    </button>
    <input class="pf-c-form-control" type="text" value="12345" name="textInput1" aria-label="Input touchspin" />
    <button class="pf-c-button pf-m-control" type="button" aria-label="Plus">
      <span class="pf-c-touchspin__icon">
        <i class="fas fa-plus" aria-hidden="true"></i>
      </span>
    </button>
  </div>
</div>
```

## Documentation

### Overview

### Usage

| Class                                           | Applied           | Outcome                                                  |
| ----------------------------------------------- | ----------------- | -------------------------------------------------------- |
| `.pf-c-touchspin`                               | `<div>`           | Initiates the touchspin component.                       |
| `.pf-c-touchspin__icon`                         | `<span>`          | Initiates the touchspin icon.                            |
| `.pf-c-touchspin__unit`                         | `<span>`          | Initiates the touchspin unit.                            |
| `--pf-c-touchspin--c-form-control--width-chars` | `.pf-c-touchspin` | Specifies the number of characters to show in the input. |
