const http = require('http');
const path = require('path');

const projectPkgJson = path.resolve(process.cwd(), 'package.json');
const pkg = require(projectPkgJson);

module.exports = function sendToAwesomeReporter(data) {
  const token = pkg.awesomeReporter.token;
  return new Promise((resolve, reject) => {
    const postData = JSON.stringify(data);
    const options = {
      hostname: 'localhost',
      port: 3001,
      path: `/api/reports?token=${token}`,
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        'Content-Length': postData.length,
      },
    };
    const req = http.request(options, res => {
      // console.log(res);
      resolve(res);
    });

    req.on('error', err => {
      reject(err);
    });

    req.write(postData);
    req.end();
  });
};
