import * as React from 'react';
import { Line } from 'victory-core';
import { ChartContainer } from '../ChartContainer';
import { ChartLabel } from '../ChartLabel';
import { ChartBulletStyles } from '../ChartTheme';
import { getBulletGroupTitleTheme, getLabelTextSize, getBulletLabelX, getBulletLabelY, getPaddingForSide } from '../ChartUtils';
export const ChartBulletGroupTitle = ({ ariaDesc, ariaTitle, capHeight = 1.1, dividerComponent = React.createElement(Line, null), padding, standalone = true, subTitle, themeColor, themeVariant, title, titleComponent = React.createElement(ChartLabel, null), 
// destructure last
theme = getBulletGroupTitleTheme(themeColor, themeVariant), height = theme.chart.height, width = theme.chart.width }) => {
    const defaultPadding = {
        bottom: getPaddingForSide('bottom', padding, theme.chart.padding),
        left: getPaddingForSide('left', padding, theme.chart.padding),
        right: getPaddingForSide('right', padding, theme.chart.padding),
        top: getPaddingForSide('top', padding, theme.chart.padding)
    };
    const labelPadding = {
        bottom: getPaddingForSide('bottom', padding, Number(theme.legend.style.labels.padding)),
        left: getPaddingForSide('left', padding, Number(theme.legend.style.labels.padding)),
        right: getPaddingForSide('right', padding, Number(theme.legend.style.labels.padding)),
        top: getPaddingForSide('top', padding, Number(theme.legend.style.labels.padding))
    };
    // Horizontal divider to render under the group title
    const getDivider = () => {
        const titleSize = getLabelTextSize({ text: title, theme });
        const subTitleSize = getLabelTextSize({ text: subTitle, theme });
        const dy = title && subTitle
            ? titleSize.height + subTitleSize.height + labelPadding.top + labelPadding.bottom
            : titleSize.height + labelPadding.top + labelPadding.bottom;
        return React.cloneElement(dividerComponent, Object.assign({ x1: defaultPadding.left, x2: width - defaultPadding.right, y1: defaultPadding.top + dy, y2: defaultPadding.top + dy, style: theme.line.style.data }, dividerComponent.props));
    };
    // Returns title
    const getTitle = () => {
        const titleProps = titleComponent ? titleComponent.props : {};
        const showBoth = title && subTitle;
        return React.cloneElement(titleComponent, Object.assign(Object.assign(Object.assign({}, (showBoth && { capHeight })), { style: [ChartBulletStyles.label.groupTitle, ChartBulletStyles.label.subTitle], text: showBoth ? [title, subTitle] : title, textAnchor: 'middle', verticalAnchor: 'middle', x: getBulletLabelX({
                chartWidth: width,
                labelPosition: 'top'
            }), y: getBulletLabelY({
                chartHeight: height,
                dy: defaultPadding.top,
                labelPosition: 'top'
            }) }), titleProps));
    };
    const groupTitle = Boolean(title) && (React.createElement(React.Fragment, null,
        getTitle(),
        getDivider()));
    return standalone ? (React.createElement(ChartContainer, { desc: ariaDesc, height: height, title: ariaTitle, width: width }, groupTitle)) : (React.createElement(React.Fragment, null, groupTitle));
};
ChartBulletGroupTitle.displayName = 'ChartBulletGroupTitle';
//# sourceMappingURL=ChartBulletGroupTitle.js.map