"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BulletQualitativeRangeTheme = exports.BulletPrimarySegmentedMeasureTheme = exports.BulletPrimaryNegativeMeasureTheme = exports.BulletPrimaryDotMeasureTheme = exports.BulletGroupTitleTheme = exports.BulletComparativeWarningMeasureTheme = exports.BulletComparativeMeasureTheme = exports.BulletComparativeErrorMeasureTheme = exports.BulletTheme = void 0;
const tslib_1 = require("tslib");
/* eslint-disable camelcase */
const chart_bullet_Height_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_bullet_Height'));
const chart_bullet_comparative_measure_Fill_Color_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_bullet_comparative_measure_Fill_Color'));
const chart_bullet_comparative_measure_stroke_Color_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_bullet_comparative_measure_stroke_Color'));
const chart_bullet_comparative_measure_stroke_Width_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_bullet_comparative_measure_stroke_Width'));
const chart_bullet_comparative_measure_error_Fill_Color_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_bullet_comparative_measure_error_Fill_Color'));
const chart_bullet_comparative_measure_error_stroke_Color_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_bullet_comparative_measure_error_stroke_Color'));
const chart_bullet_comparative_measure_error_stroke_Width_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_bullet_comparative_measure_error_stroke_Width'));
const chart_bullet_comparative_measure_warning_Fill_Color_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_bullet_comparative_measure_warning_Fill_Color'));
const chart_bullet_comparative_measure_warning_stroke_Color_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_bullet_comparative_measure_warning_stroke_Color'));
const chart_bullet_comparative_measure_warning_stroke_Width_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_bullet_comparative_measure_warning_stroke_Width'));
const chart_bullet_group_title_divider_Fill_Color_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_bullet_group_title_divider_Fill_Color'));
const chart_bullet_group_title_divider_stroke_Color_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_bullet_group_title_divider_stroke_Color'));
const chart_bullet_group_title_divider_stroke_Width_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_bullet_group_title_divider_stroke_Width'));
const chart_color_black_100_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_color_black_100'));
const chart_color_black_200_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_color_black_200'));
const chart_color_black_300_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_color_black_300'));
const chart_color_black_400_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_color_black_400'));
const chart_color_black_500_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_color_black_500'));
const chart_color_red_100_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_color_red_100'));
const chart_color_red_200_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_color_red_200'));
const chart_color_red_300_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_color_red_300'));
const chart_color_red_400_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_color_red_400'));
const chart_color_red_500_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_color_red_500'));
const chart_global_layout_Padding_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_global_layout_Padding'));
// See https://docs.google.com/document/d/1cw10pJFXWruB1SA8TQwituxn5Ss6KpxYPCOYGrH8qAY/edit#
// See https://www.patternfly.org/v3/pattern-library/data-visualization/bullet-chart/#design
// Bullet theme
exports.BulletTheme = {
    chart: {
        height: chart_bullet_Height_1.default.value
    }
};
// Bullet comparative measure error theme
exports.BulletComparativeErrorMeasureTheme = {
    bar: {
        height: chart_bullet_Height_1.default.value,
        style: {
            data: {
                fill: chart_bullet_comparative_measure_error_Fill_Color_1.default.value,
                stroke: chart_bullet_comparative_measure_error_stroke_Color_1.default.value,
                strokeWidth: chart_bullet_comparative_measure_error_stroke_Width_1.default.value
            }
        }
    }
};
// Bullet comparative measure theme
exports.BulletComparativeMeasureTheme = {
    bar: {
        height: chart_bullet_Height_1.default.value,
        style: {
            data: {
                fill: chart_bullet_comparative_measure_Fill_Color_1.default.value,
                stroke: chart_bullet_comparative_measure_stroke_Color_1.default.value,
                strokeWidth: chart_bullet_comparative_measure_stroke_Width_1.default.value
            }
        }
    }
};
// Bullet comparative measure warning theme
exports.BulletComparativeWarningMeasureTheme = {
    bar: {
        height: chart_bullet_Height_1.default.value,
        style: {
            data: {
                fill: chart_bullet_comparative_measure_warning_Fill_Color_1.default.value,
                stroke: chart_bullet_comparative_measure_warning_stroke_Color_1.default.value,
                strokeWidth: chart_bullet_comparative_measure_warning_stroke_Width_1.default.value
            }
        }
    }
};
// Bullet group title theme
exports.BulletGroupTitleTheme = {
    chart: {
        padding: {
            bottom: 0,
            left: 0,
            right: 0,
            top: chart_global_layout_Padding_1.default.value
        } // Victory incorrectly typed ThemeBaseProps.padding as number instead of PaddingProps
    },
    line: {
        style: {
            data: {
                fill: chart_bullet_group_title_divider_Fill_Color_1.default.value,
                stroke: chart_bullet_group_title_divider_stroke_Color_1.default.value,
                strokeWidth: chart_bullet_group_title_divider_stroke_Width_1.default.value
            }
        }
    }
};
// Bullet primary dot measure theme
exports.BulletPrimaryDotMeasureTheme = {
    group: {
        height: chart_bullet_Height_1.default.value
    }
};
// Bullet primary negative measure theme
exports.BulletPrimaryNegativeMeasureTheme = {
    group: {
        colorScale: [
            chart_color_red_100_1.default.value,
            chart_color_red_200_1.default.value,
            chart_color_red_300_1.default.value,
            chart_color_red_400_1.default.value,
            chart_color_red_500_1.default.value
        ],
        height: chart_bullet_Height_1.default.value
    }
};
// Bullet primary segmented measure theme
exports.BulletPrimarySegmentedMeasureTheme = {
    group: {
        height: chart_bullet_Height_1.default.value
    }
};
// Bullet qualitative range theme
exports.BulletQualitativeRangeTheme = {
    group: {
        colorScale: [
            chart_color_black_100_1.default.value,
            chart_color_black_200_1.default.value,
            chart_color_black_300_1.default.value,
            chart_color_black_400_1.default.value,
            chart_color_black_500_1.default.value
        ],
        height: chart_bullet_Height_1.default.value
    }
};
//# sourceMappingURL=bullet-theme.js.map