"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartBulletComparativeWarningMeasure = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const victory_bar_1 = require("victory-bar");
const ChartContainer_1 = require("../ChartContainer");
const ChartUtils_1 = require("../ChartUtils");
const ChartBulletComparativeMeasure_1 = require("./ChartBulletComparativeMeasure");
const ChartBulletComparativeWarningMeasure = ({ allowTooltip = true, ariaDesc, ariaTitle, barWidth, constrainToVisibleArea = false, data, domain, horizontal = true, labelComponent, labels, measureComponent = React.createElement(ChartBulletComparativeMeasure_1.ChartBulletComparativeMeasure, null), padding, standalone = true, themeColor, themeVariant, y, 
// destructure last
theme = ChartUtils_1.getBulletComparativeWarningMeasureTheme(themeColor, themeVariant), height = theme.bar.height, width = theme.bar.width }) => {
    // Comparative measure component
    const measure = React.cloneElement(measureComponent, Object.assign({ allowTooltip,
        ariaDesc,
        ariaTitle,
        barWidth,
        constrainToVisibleArea,
        data,
        domain,
        height,
        horizontal,
        labelComponent,
        labels,
        padding, standalone: false, theme,
        width,
        y }, measureComponent.props));
    return standalone ? (React.createElement(ChartContainer_1.ChartContainer, { desc: ariaDesc, height: height, title: ariaTitle, width: width }, measure)) : (React.createElement(React.Fragment, null, measure));
};
exports.ChartBulletComparativeWarningMeasure = ChartBulletComparativeWarningMeasure;
exports.ChartBulletComparativeWarningMeasure.displayName = 'ChartBulletComparativeWarningMeasure';
// Note: VictoryBar.role must be hoisted
hoist_non_react_statics_1.default(exports.ChartBulletComparativeWarningMeasure, victory_bar_1.VictoryBar);
//# sourceMappingURL=ChartBulletComparativeWarningMeasure.js.map