'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
var splitStringTransformer = function splitStringTransformer(splitBy) {
  return {
    onSubstitution: function onSubstitution(substitution, resultSoFar) {
      if (splitBy != null && typeof splitBy === 'string') {
        if (typeof substitution === 'string' && substitution.includes(splitBy)) {
          substitution = substitution.split(splitBy);
        }
      } else {
        throw new Error('You need to specify a string character to split by.');
      }
      return substitution;
    }
  };
};

exports.default = splitStringTransformer;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9zcGxpdFN0cmluZ1RyYW5zZm9ybWVyL3NwbGl0U3RyaW5nVHJhbnNmb3JtZXIuanMiXSwibmFtZXMiOlsic3BsaXRTdHJpbmdUcmFuc2Zvcm1lciIsIm9uU3Vic3RpdHV0aW9uIiwic3Vic3RpdHV0aW9uIiwicmVzdWx0U29GYXIiLCJzcGxpdEJ5IiwiaW5jbHVkZXMiLCJzcGxpdCIsIkVycm9yIl0sIm1hcHBpbmdzIjoiOzs7OztBQUFBLElBQU1BLHlCQUF5QixTQUF6QkEsc0JBQXlCO0FBQUEsU0FBWTtBQUN6Q0Msa0JBRHlDLDBCQUMxQkMsWUFEMEIsRUFDWkMsV0FEWSxFQUNDO0FBQ3hDLFVBQUlDLFdBQVcsSUFBWCxJQUFtQixPQUFPQSxPQUFQLEtBQW1CLFFBQTFDLEVBQW9EO0FBQ2xELFlBQUksT0FBT0YsWUFBUCxLQUF3QixRQUF4QixJQUFvQ0EsYUFBYUcsUUFBYixDQUFzQkQsT0FBdEIsQ0FBeEMsRUFBd0U7QUFDdEVGLHlCQUFlQSxhQUFhSSxLQUFiLENBQW1CRixPQUFuQixDQUFmO0FBQ0Q7QUFDRixPQUpELE1BSU87QUFDTCxjQUFNLElBQUlHLEtBQUosQ0FBVSxxREFBVixDQUFOO0FBQ0Q7QUFDRCxhQUFPTCxZQUFQO0FBQ0Q7QUFWd0MsR0FBWjtBQUFBLENBQS9COztrQkFhZUYsc0IiLCJmaWxlIjoic3BsaXRTdHJpbmdUcmFuc2Zvcm1lci5qcyIsInNvdXJjZXNDb250ZW50IjpbImNvbnN0IHNwbGl0U3RyaW5nVHJhbnNmb3JtZXIgPSBzcGxpdEJ5ID0+ICh7XG4gIG9uU3Vic3RpdHV0aW9uKHN1YnN0aXR1dGlvbiwgcmVzdWx0U29GYXIpIHtcbiAgICBpZiAoc3BsaXRCeSAhPSBudWxsICYmIHR5cGVvZiBzcGxpdEJ5ID09PSAnc3RyaW5nJykge1xuICAgICAgaWYgKHR5cGVvZiBzdWJzdGl0dXRpb24gPT09ICdzdHJpbmcnICYmIHN1YnN0aXR1dGlvbi5pbmNsdWRlcyhzcGxpdEJ5KSkge1xuICAgICAgICBzdWJzdGl0dXRpb24gPSBzdWJzdGl0dXRpb24uc3BsaXQoc3BsaXRCeSk7XG4gICAgICB9XG4gICAgfSBlbHNlIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignWW91IG5lZWQgdG8gc3BlY2lmeSBhIHN0cmluZyBjaGFyYWN0ZXIgdG8gc3BsaXQgYnkuJyk7XG4gICAgfVxuICAgIHJldHVybiBzdWJzdGl0dXRpb247XG4gIH0sXG59KTtcblxuZXhwb3J0IGRlZmF1bHQgc3BsaXRTdHJpbmdUcmFuc2Zvcm1lcjtcbiJdfQ==