"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Chart = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
/* eslint-disable camelcase */
const chart_legend_Margin_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_legend_Margin'));
const victory_chart_1 = require("victory-chart");
const ChartContainer_1 = require("../ChartContainer");
const ChartLegend_1 = require("../ChartLegend");
const ChartTheme_1 = require("../ChartTheme");
const ChartUtils_1 = require("../ChartUtils");
const Chart = (_a) => {
    var { ariaDesc, ariaTitle, children, legendAllowWrap = false, legendComponent = React.createElement(ChartLegend_1.ChartLegend, null), legendData, legendPosition = ChartTheme_1.ChartCommonStyles.legend.position, padding, showAxis = true, themeColor, themeVariant, 
    // destructure last
    theme = ChartUtils_1.getTheme(themeColor, themeVariant), containerComponent = React.createElement(ChartContainer_1.ChartContainer, null), legendOrientation = theme.legend.orientation, height = theme.chart.height, width = theme.chart.width } = _a, rest = tslib_1.__rest(_a, ["ariaDesc", "ariaTitle", "children", "legendAllowWrap", "legendComponent", "legendData", "legendPosition", "padding", "showAxis", "themeColor", "themeVariant", "theme", "containerComponent", "legendOrientation", "height", "width"]);
    const defaultPadding = {
        bottom: ChartUtils_1.getPaddingForSide('bottom', padding, theme.chart.padding),
        left: ChartUtils_1.getPaddingForSide('left', padding, theme.chart.padding),
        right: ChartUtils_1.getPaddingForSide('right', padding, theme.chart.padding),
        top: ChartUtils_1.getPaddingForSide('top', padding, theme.chart.padding)
    };
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign(Object.assign({ desc: ariaDesc, title: ariaTitle, theme }, containerComponent.props), { className: ChartUtils_1.getClassName({ className: containerComponent.props.className }) // Override VictoryContainer class name
     }));
    const legend = React.cloneElement(legendComponent, Object.assign({ data: legendData, orientation: legendOrientation, theme }, legendComponent.props));
    // Returns a computed legend
    const getLegend = () => {
        if (!legend.props.data) {
            return null;
        }
        let dx = 0;
        let dy = 0;
        let xAxisLabelHeight = 0;
        let legendTitleHeight = legend.props.title ? 10 : 0;
        // Adjust for axis label
        React.Children.toArray(children).map((child) => {
            if (child.type.role === 'axis' && child.props.label && !child.props.dependentAxis) {
                xAxisLabelHeight = ChartUtils_1.getLabelTextSize({ text: child.props.label, theme }).height + 10;
                legendTitleHeight = 0;
            }
        });
        if (legendPosition === ChartLegend_1.ChartLegendPosition.bottom) {
            dy += xAxisLabelHeight + legendTitleHeight;
        }
        else if (legendPosition === ChartLegend_1.ChartLegendPosition.bottomLeft) {
            dy += xAxisLabelHeight + legendTitleHeight;
            dx = -10;
        }
        // Adjust legend position when axis is hidden
        if (!showAxis) {
            dy -= chart_legend_Margin_1.default.value;
        }
        return ChartUtils_1.getComputedLegend({
            allowWrap: legendAllowWrap,
            chartType: 'chart',
            dx,
            dy,
            height,
            legendComponent: legend,
            padding: defaultPadding,
            position: legendPosition,
            theme,
            width
        });
    };
    const VictoryChartWithContainerComponent = victory_chart_1.VictoryChart;
    if (!showAxis) {
        const Null = () => null;
        VictoryChartWithContainerComponent.defaultProps.defaultAxes.dependent = React.createElement(Null, null);
        VictoryChartWithContainerComponent.defaultProps.defaultAxes.independent = React.createElement(Null, null);
    }
    // Note: containerComponent is required for theme
    return (React.createElement(VictoryChartWithContainerComponent, Object.assign({ containerComponent: container, height: height, padding: defaultPadding, theme: theme, width: width }, rest),
        children,
        getLegend()));
};
exports.Chart = Chart;
exports.Chart.displayName = 'Chart';
hoist_non_react_statics_1.default(exports.Chart, victory_chart_1.VictoryChart);
//# sourceMappingURL=Chart.js.map