// This file is meant to help with looking up the source of errors like
// "Invariant Violation: 35" and is automatically generated by the file
// @apollo/client/config/processInvariants.ts for each @apollo/client
// release. The numbers may change from release to release, so please
// consult the @apollo/client/invariantErrorCodes.js file specific to
// your @apollo/client version. This file is not meant to be imported.
{
  "@apollo/client version": "3.3.21",

  1: {
    file: "@apollo/client/cache/inmemory/policies.js",
    node: invariant(!old || old === which, "Cannot change root " + which + " __typename more than once")
  },

  2: {
    file: "@apollo/client/cache/inmemory/policies.js",
    node: new InvariantError("Cannot automatically merge arrays")
  },

  3: {
    file: "@apollo/client/cache/inmemory/policies.js",
    node: invariant(!strict, "Missing field '" + responseName + "' while computing key fields")
  },

  4: {
    file: "@apollo/client/cache/inmemory/readFromStore.js",
    node: new InvariantError("Dangling reference to missing " + objectOrReference.__ref + " object")
  },

  5: {
    file: "@apollo/client/cache/inmemory/readFromStore.js",

    node: new InvariantError("Can't find field '" + selection.name.value + "' on " + (isReference(objectOrReference)
        ? objectOrReference.__ref + " object"
        : "object " + JSON.stringify(objectOrReference, null, 2)))
  },

  6: {
    file: "@apollo/client/cache/inmemory/readFromStore.js",
    node: invariant(!isReference(value), "Missing selection set for object of type " + getTypenameFromStoreObject(store, value) + " returned for query field " + field.name.value)
  },

  7: {
    file: "@apollo/client/cache/inmemory/writeToStore.js",
    node: new InvariantError("Could not identify object " + JSON.stringify(result))
  },

  8: {
    file: "@apollo/client/cache/inmemory/writeToStore.js",
    node: new InvariantError("Missing field '" + resultFieldKey + "' in " + JSON.stringify(result, null, 2).substring(0, 100))
  },

  9: {
    file: "@apollo/client/core/ApolloClient.js",

    node: new InvariantError("To initialize Apollo Client, you must specify a 'cache' property " +
        "in the options object. \n" +
        "For more information, please visit: https://go.apollo.dev/c/docs")
  },

  10: {
    file: "@apollo/client/core/ApolloClient.js",

    node: invariant(options.fetchPolicy !== 'cache-and-network', 'The cache-and-network fetchPolicy does not work with client.query, because ' +
        'client.query can only return a single result. Please use client.watchQuery ' +
        'to receive multiple results from the cache and the network, or consider ' +
        'using a different fetchPolicy, such as cache-first or network-only.')
  },

  11: {
    file: "@apollo/client/core/LocalState.js",
    node: invariant(fragment, "No fragment named " + selection.name.value)
  },

  12: {
    file: "@apollo/client/core/QueryManager.js",
    node: new InvariantError('QueryManager stopped while query was in flight')
  },

  13: {
    file: "@apollo/client/core/QueryManager.js",
    node: invariant(mutation, 'mutation option is required. You must specify your GraphQL document in the mutation option.')
  },

  14: {
    file: "@apollo/client/core/QueryManager.js",
    node: invariant(!fetchPolicy || fetchPolicy === 'no-cache', "Mutations only support a 'no-cache' fetchPolicy. If you don't want to disable the cache, remove your fetchPolicy setting to proceed with the default mutation behavior.")
  },

  15: {
    file: "@apollo/client/core/QueryManager.js",

    node: invariant(options.query, 'query option is required. You must specify your GraphQL document ' +
        'in the query option.')
  },

  16: {
    file: "@apollo/client/core/QueryManager.js",
    node: invariant(options.query.kind === 'Document', 'You must wrap the query string in a "gql" tag.')
  },

  17: {
    file: "@apollo/client/core/QueryManager.js",
    node: invariant(!options.returnPartialData, 'returnPartialData option only supported on watchQuery.')
  },

  18: {
    file: "@apollo/client/core/QueryManager.js",
    node: invariant(!options.pollInterval, 'pollInterval option only supported on watchQuery.')
  },

  19: {
    file: "@apollo/client/core/QueryManager.js",
    node: new InvariantError('Store reset while query was in flight (not completed in link chain)')
  },

  20: {
    file: "@apollo/client/core/Reobserver.js",
    node: invariant(pollInterval, 'Attempted to start a polling query without a polling interval.')
  },

  21: {
    file: "@apollo/client/link/core/ApolloLink.js",
    node: new InvariantError('request is not implemented')
  },

  22: {
    file: "@apollo/client/link/http/checkFetcher.js",
    node: new InvariantError("\n\"fetch\" has not been found globally and no fetcher has been configured. To fix this, install a fetch package (like https://www.npmjs.com/package/cross-fetch), instantiate the fetcher, and pass it into your HttpLink constructor. For example:\n\nimport fetch from 'cross-fetch';\nimport { ApolloClient, HttpLink } from '@apollo/client';\nconst client = new ApolloClient({\n  link: new HttpLink({ uri: '/graphql', fetch })\n});\n    ")
  },

  23: {
    file: "@apollo/client/link/http/serializeFetchParameter.js",
    node: new InvariantError("Network request failed. " + label + " is not serializable: " + e.message)
  },

  24: {
    file: "@apollo/client/link/persisted-queries/index.js",

    node: invariant(options && (typeof options.sha256 === 'function' ||
        typeof options.generateHash === 'function'), 'Missing/invalid "sha256" or "generateHash" function. Please ' +
        'configure one using the "createPersistedQueryLink(options)" options ' +
        'parameter.')
  },

  25: {
    file: "@apollo/client/link/persisted-queries/index.js",
    node: invariant(forward, 'PersistedQueryLink cannot be the last link in the chain.')
  },

  26: {
    file: "@apollo/client/link/utils/validateOperation.js",
    node: new InvariantError("illegal argument: " + key)
  },

  27: {
    file: "@apollo/client/react/context/ApolloConsumer.js",

    node: invariant(context && context.client, 'Could not find "client" in the context of ApolloConsumer. ' +
        'Wrap the root component in an <ApolloProvider>.')
  },

  28: {
    file: "@apollo/client/react/context/ApolloProvider.js",

    node: invariant(context.client, 'ApolloProvider was not passed a client instance. Make ' +
        'sure you pass in your client via the "client" prop.')
  },

  29: {
    file: "@apollo/client/react/data/OperationData.js",

    node: invariant(!!client, 'Could not find "client" in the context or passed in as an option. ' +
        'Wrap the root component in an <ApolloProvider>, or pass an ' +
        'ApolloClient instance in via options.')
  },

  30: {
    file: "@apollo/client/react/data/OperationData.js",

    node: invariant(operation.type === type, "Running a " + requiredOperationName + " requires a graphql " +
        (requiredOperationName + ", but a " + usedOperationName + " was used instead."))
  },

  31: {
    file: "@apollo/client/react/hoc/hoc-utils.js",

    node: invariant(this.withRef, "To access the wrapped instance, you need to specify " +
        "{ withRef: true } in the options")
  },

  32: {
    file: "@apollo/client/react/hoc/withApollo.js",

    node: invariant(operationOptions.withRef, "To access the wrapped instance, you need to specify " +
        "{ withRef: true } in the options")
  },

  33: {
    file: "@apollo/client/react/hooks/useApolloClient.js",

    node: invariant(client, 'No Apollo Client instance can be found. Please ensure that you ' +
        'have called `ApolloProvider` higher up in your tree.')
  },

  34: {
    file: "@apollo/client/react/parser/index.js",

    node: invariant(!!document && !!document.kind, "Argument of " + document + " passed to parser was not a valid GraphQL " +
        "DocumentNode. You may need to use 'graphql-tag' or another method " +
        "to convert your operation into a document")
  },

  35: {
    file: "@apollo/client/react/parser/index.js",

    node: invariant(!fragments.length ||
        (queries.length || mutations.length || subscriptions.length), "Passing only a fragment to 'graphql' is not yet supported. " +
        "You must include a query, subscription or mutation as well")
  },

  36: {
    file: "@apollo/client/react/parser/index.js",

    node: invariant(queries.length + mutations.length + subscriptions.length <= 1, "react-apollo only supports a query, subscription, or a mutation per HOC. " +
        (document + " had " + queries.length + " queries, " + subscriptions.length + " ") +
        ("subscriptions and " + mutations.length + " mutations. ") +
        "You can use 'compose' to join multiple operation types to a component")
  },

  37: {
    file: "@apollo/client/react/parser/index.js",

    node: invariant(definitions.length === 1, "react-apollo only supports one definition per HOC. " + document + " had " +
        (definitions.length + " definitions. ") +
        "You can use 'compose' to join multiple operation types to a component")
  },

  38: {
    file: "@apollo/client/utilities/graphql/directives.js",
    node: invariant(evaledValue !== void 0, "Invalid variable referenced in @" + directive.name.value + " directive.")
  },

  39: {
    file: "@apollo/client/utilities/graphql/directives.js",
    node: invariant(directiveArguments && directiveArguments.length === 1, "Incorrect number of arguments for the @" + directiveName + " directive.")
  },

  40: {
    file: "@apollo/client/utilities/graphql/directives.js",
    node: invariant(ifArgument.name && ifArgument.name.value === 'if', "Invalid argument for the @" + directiveName + " directive.")
  },

  41: {
    file: "@apollo/client/utilities/graphql/directives.js",

    node: invariant(ifValue &&
        (ifValue.kind === 'Variable' || ifValue.kind === 'BooleanValue'), "Argument for the @" + directiveName + " directive must be a variable or a boolean value.")
  },

  42: {
    file: "@apollo/client/utilities/graphql/fragments.js",

    node: new InvariantError("Found a " + definition.operation + " operation" + (definition.name ? " named '" + definition.name.value + "'" : '') + ". " +
        'No operations are allowed when using a fragment as a query. Only fragments are allowed.')
  },

  43: {
    file: "@apollo/client/utilities/graphql/fragments.js",
    node: invariant(fragments.length === 1, "Found " + fragments.length + " fragments. `fragmentName` must be provided when there is not exactly 1 fragment.")
  },

  44: {
    file: "@apollo/client/utilities/graphql/fragments.js",
    node: invariant(fragment, "No fragment named " + selection.name.value + ".")
  },

  45: {
    file: "@apollo/client/utilities/graphql/getFromAST.js",
    node: invariant(doc && doc.kind === 'Document', "Expecting a parsed GraphQL document. Perhaps you need to wrap the query string in a \"gql\" tag? http://docs.apollostack.com/apollo-client/core.html#gql")
  },

  46: {
    file: "@apollo/client/utilities/graphql/getFromAST.js",
    node: new InvariantError("Schema type definitions not allowed in queries. Found: \"" + definition.kind + "\"")
  },

  47: {
    file: "@apollo/client/utilities/graphql/getFromAST.js",
    node: invariant(operations.length <= 1, "Ambiguous GraphQL document: contains " + operations.length + " operations")
  },

  48: {
    file: "@apollo/client/utilities/graphql/getFromAST.js",
    node: invariant(queryDef && queryDef.operation === 'query', 'Must contain a query definition.')
  },

  49: {
    file: "@apollo/client/utilities/graphql/getFromAST.js",
    node: invariant(doc.kind === 'Document', "Expecting a parsed GraphQL document. Perhaps you need to wrap the query string in a \"gql\" tag? http://docs.apollostack.com/apollo-client/core.html#gql")
  },

  50: {
    file: "@apollo/client/utilities/graphql/getFromAST.js",
    node: invariant(doc.definitions.length <= 1, 'Fragment must have exactly one definition.')
  },

  51: {
    file: "@apollo/client/utilities/graphql/getFromAST.js",
    node: invariant(fragmentDef.kind === 'FragmentDefinition', 'Must be a fragment definition.')
  },

  52: {
    file: "@apollo/client/utilities/graphql/getFromAST.js",
    node: new InvariantError('Expected a parsed GraphQL query with a query, mutation, subscription, or a fragment.')
  },

  53: {
    file: "@apollo/client/utilities/graphql/storeUtils.js",

    node: new InvariantError("The inline argument \"" + name.value + "\" of kind \"" + value.kind + "\"" +
        'is not supported. Use variables instead of inline arguments to ' +
        'overcome this limitation.')
  },

  54: {
    file: "@apollo/client/utilities/testing/mocking/mockLink.js",
    node: invariant(queryWithoutConnection, "query is required")
  }
}
