[![Build Status](https://travis-ci.com/open-cluster-management/hcm-compliance.svg?token=1xoYGv8XzWhB2heDk2My&branch=master)](https://travis-ci.com/open-cluster-management/hcm-compliance)

# HCM Compliance Manager
The HCM compliance manager provides a desired state management (CRDs and Controllers) implementation
for the HCM compliance feature in [HCM](https://github.ibm.com/IBMPrivateCloud/hybrid-cluster-manager).

## How to set up your development environment
Follow [these instructions](docs/setting-up-dev-env.md) to setup your environment.

## How to contribute
Please follow [these instructions](docs/contributing.md) to submit PRs.

## How to install and run 
Follow [these instructions](https://github.ibm.com/IBMPrivateCloud/hybrid-cluster-manager-v2-chart#klusterlet-v2) to install the compliance manager helm charts.

### Running with an example policy:
After [installing](#how-to-install-and-run), you may [create a sample compliance policy](docs/demo-examples.md#testing-with-the-sample-compliance-policy) for the managed clusters.

### Short End-to-End Demo

[![Watch the video](https://github.ibm.com/IBMPrivateCloud/hcm-compliance/blob/master/docs/photos/Screen%20Shot%20-demo.png)](https://ibm.box.com/s/zzdch1eipjiyw8s5zu602cuxvcfmil7u)

## HCM Controllers
The HCM compliance manager includes
a resource model based on [Kubernetes Custom Resource Definitions (CRDs)](https://kubernetes.io/docs/concepts/extend-kubernetes/api-extension/custom-resources/) and several CRD Controllers:

- [Propagation Controller](docs/controllers.md#propagation-controller)
- [Override Controller](docs/controllers.md#override-controller)
- [Status Aggregation Controller](docs/controllers.md#status-aggregation-controller)
- [Sync Controller](docs/controllers.md#sync-controller)
- [Policy Controller](docs/controllers.md#policy-controller)
- [Compliance Controller](docs/controllers.md#compliance-controller)
- [Istio Controller](docs/controllers.md#istio-controller)

## Feature specs
Feature specs are being defined [here](https://github.ibm.com/IBMPrivateCloud/roadmap/blob/master/feature-specs/hcm/compliance-manager/compliance-spec.md)

## Reporting bugs or opening issues for new features
Please open new issues in the [HCM roadmap repo](https://github.ibm.com/IBMPrivateCloud/roadmap/labels/squad%3Ahcm-compliance) and make
sure you use at least the labels `multicluster` and `squad:hcm-compliance`.
You may also add the labels `bug` and `feature` to further help
categorize your issue. 


