# Demonstrating AccessPolicy skeleton

Consider deleting any objects of type `accesspolicy` from cluster.
Consider deleting the `AccessPolicy` CRD:

    kubectl delete crd accesspolicies.accesspolicy.mcm.ibm.com

In [root directory](../..), run as follows

    go run cmd/accesspolicy/accesspolicy.go  --kubeconfig=/home/vagrant/.kube/config -logtostderr=true -v=5

You should see something like:

    I0620 17:55:59.857802   16880 accesspolicy.go:35] Started with cluster name

In a separate window, verify that the CRD was created:

    kubectl get crd accesspolicies.accesspolicy.mcm.ibm.com

Create an object:

    kubectl apply -f artifacts/ap1.yaml

In the log, you should see, among other things logs indicating that the reconcile methods have been called: 

    I0620 18:03:23.519063   16880 handler.go:22] accesspolicy.Reconcile called
    I0620 18:03:23.683207   16880 handler.go:41] accesspolicy.HandleAccessPolicy() called

Similarly, modify the object defintion and reapply.  The log should show reconcile called again.  Delete the object:

    kubectl delete apl ap1
    
You should see a log message indicating deletion:

    I0620 19:22:35.094009   16880 handler.go:34] Deleting resource

For reference: the [CRD definition](https://github.ibm.com/IBMPrivateCloud/hcm-compliance/blob/accesspolicy/crd/accesspolicycrdscheme.yaml), the [AccessPolicy type definitions](https://github.ibm.com/IBMPrivateCloud/hcm-compliance/blob/accesspolicy/pkg/apis/accesspolicy/v1alpha1/types.go), the [contoller hander](https://github.ibm.com/IBMPrivateCloud/hcm-compliance/blob/accesspolicy/pkg/accesspolicy/handler.go).