# Contributing to HCM Compliance

To start contributing, [setup you development environment](setting-up-dev-env.md).
Write your new feature or fix a bug, and add new tests for it with [go testing](https://golang.org/pkg/testing/).

You may find examples of existing tests [here](../test/integration/sync_test.go). Note
that we use the [assert package](https://github.com/stretchr/testify) to semplify writing 
tests assertions.

## Submitting your PR

For more information on how to submit PRs, please read [this](https://gist.github.com/Chaser324/ce0505fbed06b947d962)
especially the section about [Doing Your Work](https://gist.github.com/Chaser324/ce0505fbed06b947d962#doing-your-work)

Specifically:

* Create your branch:
    ```
    # Checkout the master branch - you want your new branch to come from master
    git checkout master

    # Create a new branch named newfeature (give your branch its own simple informative name)
    git branch newfeature

    # Switch to your new branch
    git checkout newfeature
    ```

* Do your work on your feature

* Clean up your branch
    ```
    # Fetch upstream master and merge with your repo's master branch
    git fetch upstream
    git checkout master
    git merge upstream/master

    # If there were any new commits, rebase your development branch
    git checkout newfeature
    git rebase master

    # Rebase all commits on your development branch & squash commits
    git checkout
    git rebase -i master
    ```

* Push your commit(s)
    ```
    git push
    ```
***Hint***:
You may create an alias or a bash script for automating all of the above steps. For example, you might add an alias such as the following to your `~/.bash_profile`:

```bash
alias gsync="git fetch origin && git checkout master &&  git merge origin/master && git checkout <branch-name> && git rebase master && git checkout"
```

where `<branch-name>` is the name of your branch. You should run the above to rebase periodically after your PR is merged, and before submitting new PRs. Make sure you committed your changes before running it.

Once you've committed and pushed all of your changes to GitHub, go to the [project page](https://github.ibm.com/IBMPrivateCloud/hcm-compliance) and click on the `New Pull Request` button. 