# HCM Compliance Manager Controllers

## Propagation Controller
The propagation controller runs in HCM and watches for policy compliance templates on the HCM
API server. When a new policy compliance template is created, the propagation controller 
uses the cluster selector information in the policy to create copy of the policy for each cluster
and to place the cluster-specific policy in a namespace associated with each cluster.
If the policy has cluster-specific overrides, the cluster-level policy is placed in a staging
area until overrides are resolved.

## Override Controller
The override controller runs in HCM and watches for staged policy compliance templates on the HCM
API server. It applies the required overrides and then moves the processed cluster-level policies
from the staging area to the cluster-specific namespace.

## Status Aggregation Controller
The status aggregation controller runs in HCM and aggregates the status from the cluster-level policies to the policy compliance template that originated the cluster-level policies. Since the user
interacts with the policy compliance templates, it is expected that the an aggregated status
for the compliance is provided in that document. The aggregate is not intended as a copy
of all the information of all the cluster-specific policies, but rather as a summary or set
of statistics on the compliance of the affected clusters, with links to detailed info in individual
clusters.

## Compliance Controller
The Compliance Controller runs on HCM and provides and orchestrates the enforcement or check
of policies across different clusters.

## Sync Controller
HCM sync controllers synchronize CRDs from the HCM API server to the managed API servers.
An HCM sync controllers is installed on each managed kubernetes cluster and watches CRDs on a namespace associated with the managed cluster. If a new CRD gets created on the watched namespace,
the HCM sync controller replicates the CRD on the local cluster. If the CRD specs are updated
on the HCM API server, the specs are sync'd updated on the managed cluster as well. If the CRD status
is updated on the managed cluster, the status is sync'd and updated on the HCM API server as well.

## Policy Controller
The Policy Controller runs on each managed cluster and enforces or checks the policies defined by the HCM administrator.