# Running Compliance Demo Examples

## Testing with the sample compliance policy

To run the examples you should install first the [HCM v2 helm chart](https://github.ibm.com/IBMPrivateCloud/hybrid-cluster-manager-v2-chart)
have on a single cluster or at least two clusters install, as documented
in the instructions.

Open two terminals; one terminal may be used to apply a compliance
policy and the other one on the managed cluster. Keep in mind that switching
the `kubectl` context on one terminal will switch the context in all
terminal, unless you create copies of the `KUBECONFIG` file and use
a different file for each different terminal, each with a different
context.

Let's assume for now that you are using the same `KUBECONFIG`.

Make sure you are in the home directory of this project in both terminals.

```
cd $GOPATH/src/github.ibm.com/IBMPrivateCloud/hcm-compliance
```

Let's assume that you have done a two clusters install and the context names of the two
clusters are `mk1` and `mk2`. 

*TIP* - create a copy of your current $KUBECONFIG file (default is ~/.kube/config), for example:

```bash
cp  ~/.kube/config  ~/.kube/config-mk2
```

On the first terminal (HCM cluster) run:

```bash
export KUBECONFIG=~/.kube/config
kubectl config use-context mk1
```

and on the second terminal (managed cluster) run:

```bash
export KUBECONFIG=~/.kube/config-mk2
kubectl config use-context mk2
```

On the managed cluster, you may also run the following commands to check you do not have
any compliance policy yet and there are no roles created as part of compliance enforcement
yet:

```bash
kubectl get compliances --all-namespaces
kubectl get policies --all-namespaces
kubectl  get roles --all-namespaces
```

On the management cluster, check that the managed cluster is registered with the HCM cluster:

```bash
kubectl get clusters --all-namespaces
```

Finally, have a look to the file for the compliance policy you want to apply, for example:

```bash
cat artifacts/compliances/compliance-v0.2.yaml
```

Since the example policy uses a `matchNames` selector, if the managed cluster has a different name then `mk2` you may have to create a new copy and edit the copy to use the name of your cluster. It has to match the name retrieved with `kubectl get clusters --all-namespaces`. Note that the HCM compliance implementation supports also the `matchLabels` selector, so you may also
add a label to the cluster object and use the label selector.

On the management cluster, apply the compliance policy with the command:

```bash
 kubectl apply -f  artifacts/compliances/compliance-v0.2.yaml -n hcm
```

You may bow verify that in the management cluster a per-cluster policy was
propagated to the cluster-specific namespace:

```bash
kubectl get compliances --all-namespaces
NAMESPACE   NAME          AGE
hcm-mk2     compliance1   9s
hcm         compliance1   9s
```

On the managed cluster, check that the compliance policy was locally replicated:

```bash
kubectl get compliances --all-namespaces
NAMESPACE   NAME          AGE
hcm-mk2     compliance1   2m
```

You may also check that policies have been extracted from the compliance:

```bash
kubectl get policies --all-namespaces
NAMESPACE   NAME       AGE
hcm-mk2     policy02   3m
```

Finall, verify that the role defined in the policy (which was an `enforce` type
of policy, has been created.

```bash
kubectl get role --all-namespaces
NAMESPACE     NAME                                             AGE
default       operator                                         4m
hcm-mk2       operator                                         4m
```

You may also try to delete the role from the default namespace and verify that it gets 
re-created:

```bash
kubectl delete role operator
kubectl get role --all-namespaces
```

### Checking status

You may get a summary of the compliance status of each cluster by simply running the following
command on the HCM cluster:

```bash
kubectl describe compliance -n hcm
```

In the `Status` section you should see the following summary:

```yaml
Status:
  Hcm - Mk 2:
    Policy 02:
      Compliant:  Compliant
      Valid:      true
```      

You may also look at the replicated objects on the local cluster, for example:

```bash
kubectl describe compliance -n hcm-mk2
```

You may also look at the logs for the different controllers as illustrated [here](hhttps://github.ibm.com/IBMPrivateCloud/hybrid-cluster-manager-v2-chart/#showing-logs-for-the-controllers-in-the-managed-cluster).






