# Setting up your development environment

1. [Install Go](https://golang.org/doc/install) and setup your [GOPATH](https://github.com/golang/go/wiki/SettingGOPATH)

2. Create the following directory under `$GOPATH/src`

```bash
mkdir -p $GOPATH/src/github.ibm.com/IBMPrivateCloud
```

3. Clone the repo:

```bash
cd $GOPATH/src/github.ibm.com/IBMPrivateCloud
git clone git@github.ibm.com:IBMPrivateCloud/hcm-compliance.git
cd hcm-compliance
```

4. Install go dependencies

Install [dep](https://github.com/golang/dep#installation), and run the following command
to download all the dependencies in the `vendor` directory:

```bash
dep ensure
```

5. [Setup your test environment](https://github.ibm.com/seed/seed-sdk/blob/master/docs/testing.md#using-the-testing-framework)

6. Run tests to verify your environment is correctly setup.

```bash
make test
```

## Miscellaneus

### How to create a tagged version

1. On master, tag with a comment, e.g.

```
git tag -a 3.1.1 -m "version 3.1.1"
```

2. Push the tag

```
git push origin 3.1.1
```

### How to move a tag
This is only done if we want to incorporate last minute fixes before the final release is cut.

1. Delete the tag on any remote before you push

```
git push origin :refs/tags/<tagname>
```

2. Replace the tag to reference the most recent commit

```
git tag -fa <tagname>
```

3. Push the tag to the remote origin

```
git push origin master --tags
```

## Troubleshooting

Getting klusterlet logs
```
kubectl logs -n kube-system $(kubectl get pods -l component=klusterlet -n kube-system -o jsonpath='{.items[*].metadata.name }') <pod-name>
```

for example
```
kubectl logs -n kube-system $(kubectl get pods -l component=klusterlet -n kube-system -o jsonpath='{.items[*].metadata.name }') policy-controller
```