#!/bin/bash

# Licensed Materials - Property of IBM
# (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
# Note to U.S. Government Users Restricted Rights:
# Use, duplication or disclosure restricted by GSA ADP Schedule
# Contract with IBM Corp.

set -e

LOG_LEVEL="${LOG_LEVEL:-7}"
NAMESPACE="${NAMESPACE:-mcm-icp2}"
WATCHNS=$NAMESPACE
#CERT_SECRET_NAME="${CERT_SECRET_NAME:-hcmk-v2-hcm-v2-klusterlet-cert}"
ROOT=$(dirname ${BASH_SOURCE})/..
(cd $ROOT && go run cmd/sync-controller/sync.go \
    --remote-kubeconfig=$KUBECONFIG \
    --kubeconfig=$KUBECONFIG_MK2 \
    --klusterlet-ns=$NAMESPACE \
    --watch-ns=$WATCHNS  \
    --cert-secret-name=$CERT_SECRET_NAME \
    -logtostderr=true \
    -v="$LOG_LEVEL")
