// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

package accesspolicy

import (
	//This package is required when using the IBM Cloud Clusters for its authentication
	_ "k8s.io/client-go/plugin/pkg/client/auth/oidc"

	"github.com/golang/glog"

	corev1 "k8s.io/api/core/v1"
	apierrors "k8s.io/apimachinery/pkg/api/errors"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	kubernetes "k8s.io/client-go/kubernetes"
)

// servicesmanager is an implementation for managing the lifecycle
// of Services resources in the cluster.
type servicesmanager struct {
	clientset *kubernetes.Clientset
}

var servicemngr *servicesmanager

// getNetworkPoliciesManager will return the networkpoliciesmanager singleton
func getServicesManager(cset *kubernetes.Clientset) *servicesmanager {
	if servicemngr == nil {
		servicemngr = &servicesmanager{
			clientset: cset,
		}
	}

	return servicemngr
}

// get will get a Service by the provided name. It the NetworkPolicy is not found,
// it will return nil for the policy. If failed find if it exists or get the policy the error will
// be returned.
func (mgr *servicesmanager) get(name string, ns string) (*corev1.Service, error) {
	options := metav1.GetOptions{}
	service, err := mgr.clientset.Core().Services(ns).Get(name, options)
	if err != nil {
		if apierrors.IsNotFound(err) {
			glog.Infof("Service '%s' not found", name)
			return nil, nil
		}
		return nil, err
	}

	glog.Infof("Service '%s' found", name)
	return service, nil
}
