// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

package v1alpha1

import (
	// rbacv1 "k8s.io/api/rbac/v1"
	resv1 "github.com/open-cluster-management/seed-sdk/pkg/types/apis/resource/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// AccessPolicyResourcePlural as a plural name
const AccessPolicyResourcePlural = "accesspolicies"

// AccessPolicy is a specification for a Policy resource
// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object
// +genclient
type AccessPolicy struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata"`

	Spec AccessPolicySpec `json:"spec"`
	//ResourceStatus `json:"status,omitempty"` //TODO complete the status
}

// AccessPolicySpec is the spec for a AccessPolicy resource
type AccessPolicySpec struct {
	Namespaces  string             `json:"namespaces"`
	Source      Microservice       `json:"source"`
	Destination Microservice       `json:"destination"`
	Rules       []AccessPolicyRule `json:"rules"`
}

// Microservice defines how to select the source and destination of an AccessPolicy
type Microservice struct {
	Service string `json:"service"`
}

// AccessPolicyRule is a
type AccessPolicyRule struct {
	Protocol  string   `json:"protocol,omitempty"`
	Port      int      `json:"port,omitempty"`
	Actions   []string `json:"actions,omitempty"`
	Resources []string `json:"resources,omitempty"`
}

// AccessPolicyList is a list of AccessPolicy resources
// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object
// +k8s:lister-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object
type AccessPolicyList struct {
	// metav1.TypeMeta `json:",inline"`
	// metav1.ListMeta `json:"metadata"`
	resv1.ResourceList `json:",inline"`

	Items []AccessPolicy `json:"items"`
}
