// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.
// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	clientset "github.com/open-cluster-management/hcm-compliance/pkg/client/clientset/versioned"
	accesspolicyv1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/client/clientset/versioned/typed/accesspolicy/v1alpha1"
	fakeaccesspolicyv1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/client/clientset/versioned/typed/accesspolicy/v1alpha1/fake"
	compliancev1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/client/clientset/versioned/typed/compliance/v1alpha1"
	fakecompliancev1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/client/clientset/versioned/typed/compliance/v1alpha1/fake"
	policyv1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/client/clientset/versioned/typed/policy/v1alpha1"
	fakepolicyv1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/client/clientset/versioned/typed/policy/v1alpha1/fake"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/discovery"
	fakediscovery "k8s.io/client-go/discovery/fake"
	"k8s.io/client-go/testing"
)

// NewSimpleClientset returns a clientset that will respond with the provided objects.
// It's backed by a very simple object tracker that processes creates, updates and deletions as-is,
// without applying any validations and/or defaults. It shouldn't be considered a replacement
// for a real clientset and is mostly useful in simple unit tests.
func NewSimpleClientset(objects ...runtime.Object) *Clientset {
	o := testing.NewObjectTracker(scheme, codecs.UniversalDecoder())
	for _, obj := range objects {
		if err := o.Add(obj); err != nil {
			panic(err)
		}
	}

	cs := &Clientset{}
	cs.discovery = &fakediscovery.FakeDiscovery{Fake: &cs.Fake}
	cs.AddReactor("*", "*", testing.ObjectReaction(o))
	cs.AddWatchReactor("*", func(action testing.Action) (handled bool, ret watch.Interface, err error) {
		gvr := action.GetResource()
		ns := action.GetNamespace()
		watch, err := o.Watch(gvr, ns)
		if err != nil {
			return false, nil, err
		}
		return true, watch, nil
	})

	return cs
}

// Clientset implements clientset.Interface. Meant to be embedded into a
// struct to get a default implementation. This makes faking out just the method
// you want to test easier.
type Clientset struct {
	testing.Fake
	discovery *fakediscovery.FakeDiscovery
}

func (c *Clientset) Discovery() discovery.DiscoveryInterface {
	return c.discovery
}

var _ clientset.Interface = &Clientset{}

// AccesspolicyV1alpha1 retrieves the AccesspolicyV1alpha1Client
func (c *Clientset) AccesspolicyV1alpha1() accesspolicyv1alpha1.AccesspolicyV1alpha1Interface {
	return &fakeaccesspolicyv1alpha1.FakeAccesspolicyV1alpha1{Fake: &c.Fake}
}

// Accesspolicy retrieves the AccesspolicyV1alpha1Client
func (c *Clientset) Accesspolicy() accesspolicyv1alpha1.AccesspolicyV1alpha1Interface {
	return &fakeaccesspolicyv1alpha1.FakeAccesspolicyV1alpha1{Fake: &c.Fake}
}

// ComplianceV1alpha1 retrieves the ComplianceV1alpha1Client
func (c *Clientset) ComplianceV1alpha1() compliancev1alpha1.ComplianceV1alpha1Interface {
	return &fakecompliancev1alpha1.FakeComplianceV1alpha1{Fake: &c.Fake}
}

// Compliance retrieves the ComplianceV1alpha1Client
func (c *Clientset) Compliance() compliancev1alpha1.ComplianceV1alpha1Interface {
	return &fakecompliancev1alpha1.FakeComplianceV1alpha1{Fake: &c.Fake}
}

// PolicyV1alpha1 retrieves the PolicyV1alpha1Client
func (c *Clientset) PolicyV1alpha1() policyv1alpha1.PolicyV1alpha1Interface {
	return &fakepolicyv1alpha1.FakePolicyV1alpha1{Fake: &c.Fake}
}

// Policy retrieves the PolicyV1alpha1Client
func (c *Clientset) Policy() policyv1alpha1.PolicyV1alpha1Interface {
	return &fakepolicyv1alpha1.FakePolicyV1alpha1{Fake: &c.Fake}
}
