// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.
// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/apis/accesspolicy/v1alpha1"
	scheme "github.com/open-cluster-management/hcm-compliance/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// AccessPoliciesGetter has a method to return a AccessPolicyInterface.
// A group's client should implement this interface.
type AccessPoliciesGetter interface {
	AccessPolicies(namespace string) AccessPolicyInterface
}

// AccessPolicyInterface has methods to work with AccessPolicy resources.
type AccessPolicyInterface interface {
	Create(*v1alpha1.AccessPolicy) (*v1alpha1.AccessPolicy, error)
	Update(*v1alpha1.AccessPolicy) (*v1alpha1.AccessPolicy, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.AccessPolicy, error)
	List(opts v1.ListOptions) (*v1alpha1.AccessPolicyList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.AccessPolicy, err error)
	AccessPolicyExpansion
}

// accessPolicies implements AccessPolicyInterface
type accessPolicies struct {
	client rest.Interface
	ns     string
}

// newAccessPolicies returns a AccessPolicies
func newAccessPolicies(c *AccesspolicyV1alpha1Client, namespace string) *accessPolicies {
	return &accessPolicies{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the accessPolicy, and returns the corresponding accessPolicy object, and an error if there is any.
func (c *accessPolicies) Get(name string, options v1.GetOptions) (result *v1alpha1.AccessPolicy, err error) {
	result = &v1alpha1.AccessPolicy{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("accesspolicies").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of AccessPolicies that match those selectors.
func (c *accessPolicies) List(opts v1.ListOptions) (result *v1alpha1.AccessPolicyList, err error) {
	result = &v1alpha1.AccessPolicyList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("accesspolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested accessPolicies.
func (c *accessPolicies) Watch(opts v1.ListOptions) (watch.Interface, error) {
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("accesspolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Watch()
}

// Create takes the representation of a accessPolicy and creates it.  Returns the server's representation of the accessPolicy, and an error, if there is any.
func (c *accessPolicies) Create(accessPolicy *v1alpha1.AccessPolicy) (result *v1alpha1.AccessPolicy, err error) {
	result = &v1alpha1.AccessPolicy{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("accesspolicies").
		Body(accessPolicy).
		Do().
		Into(result)
	return
}

// Update takes the representation of a accessPolicy and updates it. Returns the server's representation of the accessPolicy, and an error, if there is any.
func (c *accessPolicies) Update(accessPolicy *v1alpha1.AccessPolicy) (result *v1alpha1.AccessPolicy, err error) {
	result = &v1alpha1.AccessPolicy{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("accesspolicies").
		Name(accessPolicy.Name).
		Body(accessPolicy).
		Do().
		Into(result)
	return
}

// Delete takes name of the accessPolicy and deletes it. Returns an error if one occurs.
func (c *accessPolicies) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("accesspolicies").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *accessPolicies) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("accesspolicies").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched accessPolicy.
func (c *accessPolicies) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.AccessPolicy, err error) {
	result = &v1alpha1.AccessPolicy{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("accesspolicies").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
