// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.
// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/apis/compliance/v1alpha1"
	scheme "github.com/open-cluster-management/hcm-compliance/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// CompliancesGetter has a method to return a ComplianceInterface.
// A group's client should implement this interface.
type CompliancesGetter interface {
	Compliances(namespace string) ComplianceInterface
}

// ComplianceInterface has methods to work with Compliance resources.
type ComplianceInterface interface {
	Create(*v1alpha1.Compliance) (*v1alpha1.Compliance, error)
	Update(*v1alpha1.Compliance) (*v1alpha1.Compliance, error)
	UpdateStatus(*v1alpha1.Compliance) (*v1alpha1.Compliance, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.Compliance, error)
	List(opts v1.ListOptions) (*v1alpha1.ComplianceList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.Compliance, err error)
	ComplianceExpansion
}

// compliances implements ComplianceInterface
type compliances struct {
	client rest.Interface
	ns     string
}

// newCompliances returns a Compliances
func newCompliances(c *ComplianceV1alpha1Client, namespace string) *compliances {
	return &compliances{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the compliance, and returns the corresponding compliance object, and an error if there is any.
func (c *compliances) Get(name string, options v1.GetOptions) (result *v1alpha1.Compliance, err error) {
	result = &v1alpha1.Compliance{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("compliances").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Compliances that match those selectors.
func (c *compliances) List(opts v1.ListOptions) (result *v1alpha1.ComplianceList, err error) {
	result = &v1alpha1.ComplianceList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("compliances").
		VersionedParams(&opts, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested compliances.
func (c *compliances) Watch(opts v1.ListOptions) (watch.Interface, error) {
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("compliances").
		VersionedParams(&opts, scheme.ParameterCodec).
		Watch()
}

// Create takes the representation of a compliance and creates it.  Returns the server's representation of the compliance, and an error, if there is any.
func (c *compliances) Create(compliance *v1alpha1.Compliance) (result *v1alpha1.Compliance, err error) {
	result = &v1alpha1.Compliance{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("compliances").
		Body(compliance).
		Do().
		Into(result)
	return
}

// Update takes the representation of a compliance and updates it. Returns the server's representation of the compliance, and an error, if there is any.
func (c *compliances) Update(compliance *v1alpha1.Compliance) (result *v1alpha1.Compliance, err error) {
	result = &v1alpha1.Compliance{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("compliances").
		Name(compliance.Name).
		Body(compliance).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *compliances) UpdateStatus(compliance *v1alpha1.Compliance) (result *v1alpha1.Compliance, err error) {
	result = &v1alpha1.Compliance{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("compliances").
		Name(compliance.Name).
		SubResource("status").
		Body(compliance).
		Do().
		Into(result)
	return
}

// Delete takes name of the compliance and deletes it. Returns an error if one occurs.
func (c *compliances) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("compliances").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *compliances) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("compliances").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched compliance.
func (c *compliances) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.Compliance, err error) {
	result = &v1alpha1.Compliance{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("compliances").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
