// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.
// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/apis/accesspolicy/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// AccessPolicyLister helps list AccessPolicies.
type AccessPolicyLister interface {
	// List lists all AccessPolicies in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.AccessPolicy, err error)
	// AccessPolicies returns an object that can list and get AccessPolicies.
	AccessPolicies(namespace string) AccessPolicyNamespaceLister
	AccessPolicyListerExpansion
}

// accessPolicyLister implements the AccessPolicyLister interface.
type accessPolicyLister struct {
	indexer cache.Indexer
}

// NewAccessPolicyLister returns a new AccessPolicyLister.
func NewAccessPolicyLister(indexer cache.Indexer) AccessPolicyLister {
	return &accessPolicyLister{indexer: indexer}
}

// List lists all AccessPolicies in the indexer.
func (s *accessPolicyLister) List(selector labels.Selector) (ret []*v1alpha1.AccessPolicy, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.AccessPolicy))
	})
	return ret, err
}

// AccessPolicies returns an object that can list and get AccessPolicies.
func (s *accessPolicyLister) AccessPolicies(namespace string) AccessPolicyNamespaceLister {
	return accessPolicyNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// AccessPolicyNamespaceLister helps list and get AccessPolicies.
type AccessPolicyNamespaceLister interface {
	// List lists all AccessPolicies in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.AccessPolicy, err error)
	// Get retrieves the AccessPolicy from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.AccessPolicy, error)
	AccessPolicyNamespaceListerExpansion
}

// accessPolicyNamespaceLister implements the AccessPolicyNamespaceLister
// interface.
type accessPolicyNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all AccessPolicies in the indexer for a given namespace.
func (s accessPolicyNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.AccessPolicy, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.AccessPolicy))
	})
	return ret, err
}

// Get retrieves the AccessPolicy from the indexer for a given namespace and name.
func (s accessPolicyNamespaceLister) Get(name string) (*v1alpha1.AccessPolicy, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("accesspolicy"), name)
	}
	return obj.(*v1alpha1.AccessPolicy), nil
}
