// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

// Package propagator handles policy template propagation logic
package propagator

import (
	"k8s.io/cluster-registry/pkg/apis/clusterregistry/v1alpha1"
	//"context"

	"reflect"
	"testing"

	"github.com/open-cluster-management/seed-sdk/pkg/util"

	"github.com/stretchr/testify/mock"

	policyv1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/apis/policy/v1alpha1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

type mockClusterLister struct {
	mock.Mock
}

func (m *mockClusterLister) Clusters(ns string) [1]v1alpha1.Cluster {
	cluster := v1alpha1.Cluster{
		ObjectMeta: metav1.ObjectMeta{
			Name: "cluster1",
		},
	}
	toReturn := [...]v1alpha1.Cluster{cluster}
	return toReturn
}

func TestHandlePolicyReconcile(t *testing.T) {
	// propagator := NewPropagator()
	// lister := new(mockClusterLister)

	// propagator.ClusterLister = lister
	// plc := policyv1alpha1.Policy{
	// 	TypeMeta: metav1.TypeMeta{
	// 		Kind:       "Policy",
	// 		APIVersion: "policy.mcm.ibm.com/v1alpha1",
	// 	},
	// 	ObjectMeta: metav1.ObjectMeta{
	// 		Name:      "policy-1",
	// 		Namespace: "default",
	// 	},
	// 	Spec: policyv1alpha1.PolicySpec{
	// 		ComplianceType:    "musthave",
	// 		RemediationAction: "enforce",
	// 		Namespaces: policyv1alpha1.Target{
	// 			Include: []string{"*"},
	// 		},
	// 	},
	// 	Status: policyv1alpha1.PolicyStatus{
	// 		PlacementBindings: []string{"binding-policy"},
	// 		PlacementPolicies: []string{"placement-policy"},
	// 		Status: policyv1alpha1.ComplianceMap{
	// 			"cluster1": &policyv1alpha1.CompliancePerClusterStatus{
	// 				ClusterName:     "cluster1",
	// 				ComplianceState: "NonCompliant",
	// 			},
	// 		},
	// 	},
	// }
	// propagator.handlePolicyReconcile(nil, &plc)
}

func TestCopyStatus(t *testing.T) {
	hcmObj := policyv1alpha1.Policy{
		TypeMeta: metav1.TypeMeta{
			Kind:       "Policy",
			APIVersion: "policy.mcm.ibm.com/v1alpha1",
		},
		ObjectMeta: metav1.ObjectMeta{
			Name:      "policy-1",
			Namespace: "default",
			//SelfLink:  "/apis/policy.mcm.ibm.com/v1alpha1/namespaces/default/policies/" + name,
		},
		Spec: policyv1alpha1.PolicySpec{
			ComplianceType:    "musthave",
			RemediationAction: "enforce",
			Namespaces: policyv1alpha1.Target{
				Include: []string{"*"},
			},
		},
		Status: policyv1alpha1.PolicyStatus{
			PlacementBindings: []string{"binding-policy"},
			PlacementPolicies: []string{"placement-policy"},
			Status: policyv1alpha1.ComplianceMap{
				"cluster1": &policyv1alpha1.CompliancePerClusterStatus{
					ClusterName:     "cluster1",
					ComplianceState: "NonCompliant",
				},
			},
		},
	}
	newObj := policyv1alpha1.Policy{
		TypeMeta: metav1.TypeMeta{
			Kind:       "Policy",
			APIVersion: "policy.mcm.ibm.com/v1alpha1",
		},
		ObjectMeta: metav1.ObjectMeta{
			Name:      "policy-1",
			Namespace: "default",
			//SelfLink:  "/apis/policy.mcm.ibm.com/v1alpha1/namespaces/default/policies/" + name,
		},
		Spec: policyv1alpha1.PolicySpec{
			ComplianceType:    "musthave",
			RemediationAction: "inform",
			Namespaces: policyv1alpha1.Target{
				Include: []string{"*"},
			},
		},
		Status: policyv1alpha1.PolicyStatus{
			PlacementBindings: []string{"binding-policy"},
			PlacementPolicies: []string{"placement-policy"},
			Status: policyv1alpha1.ComplianceMap{
				"cluster1": &policyv1alpha1.CompliancePerClusterStatus{
					ClusterName:     "cluster1",
					ComplianceState: "Compliant",
				},
			},
		},
	}
	copyStatus(newObj, &hcmObj)
	if !reflect.DeepEqual(util.GetField(hcmObj, Status), util.GetField(newObj, Status)) {
		t.Errorf("status: %s", util.GetField(hcmObj, Status))
		t.Errorf("copied status: %s", util.GetField(newObj, Status))
		t.Fatal("Error: status did not copy properly")
	}
}
