
# Compliance Generic Testing with kubectl

The `testCompliance` script uses `kubectl` to test the compliance-controller and the policy-controller behavior.

It creates a compliance with a policy comprising an RBAC role and a generic object (a namespace object). The it changes the attributes of the compliance switching the `remediationAction` from `inform` to `enforce` and vice versa. It also dchanges the `complianceType` from `musthave` to `mustnothave`. 

The script performs multiple tests, and is configurable to run in multiple iterations to make sure the results are consistent across runs.

# To run the tests:

Make sure the Klusterlet is installed, and the compliance-controller and the policy-controller have started. (Refer to the [troubleshooting](https://github.ibm.com/IBMPrivateCloud/hcm-compliance/blob/master/troubleshooting.md) guide if you need more information).

This script takes 4 input parameters, e.g.:

```bash
./testCompliance.sh ~/.kube/conf default 15 6
```

- `parameter 1`: '`~/.kube/conf`' is the KUBECONFIG file path
- `parameter 2`: '`default`' is the namespace where the compliance is created, it should be = `'--watch-ns=XXX'` flag used in the compliance-controller
- `parameter 3`: '`15`' is the time in seconds to wait before checking the result of a test, `the default is 10 seconds`, it should be > 2 x '--reconcilefrequency' flag used for the policy-controller that is by `default 3 seconds`.
- `parameter 4`: '`6`' is the number of iteration the test is repeated, to make sure the results are consistent across runs. `The default is 3 iterations`.

# Expected Result:

At the end of the script you should see summary, at any point in time, if the actual result is different than the expected one, the script will exit with a non-zero status.

```txt
------summary-----
Congratulations!
all tests in 3 iterations have completed successfully!!!
-----------------
```