#!/bin/bash

# Licensed Materials - Property of IBM
# (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
# Note to U.S. Government Users Restricted Rights:
# Use, duplication or disclosure restricted by GSA ADP Schedule
# Contract with IBM Corp.

set -o errexit
set -o nounset
set -o pipefail

SCRIPT_ROOT=$(dirname ${BASH_SOURCE})/..
CODEGEN_PKG=${CODEGEN_PKG:-$(cd ${SCRIPT_ROOT}; ls -d -1 ./vendor/k8s.io/code-generator 2>/dev/null || echo ${GOPATH}/src/k8s.io/code-generator)}

${CODEGEN_PKG}/generate-groups.sh \
all \
github.com/open-cluster-management/hcm-compliance/pkg/client \
github.com/open-cluster-management/hcm-compliance/pkg/apis \
"policy:v1alpha1 accesspolicy:v1alpha1 compliance:v1alpha1"  \
--go-header-file ${SCRIPT_ROOT}/hack/custom-boilerplate.go.txt


cd $SCRIPT_ROOT && go run vendor/github.com/open-cluster-management/seed-sdk/cmd/seed/main.go generate -f ${SCRIPT_ROOT}/hack/custom-boilerplate.go.txt

#deepcopy,lister,informer
