// +build !ignore_autogenerated
// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.
// Code generated by seed. DO NOT EDIT.

package v1alpha1

import (
	"time"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/client-go/rest"

	"github.com/open-cluster-management/seed-sdk/pkg/registry/clientsets"
	"github.com/open-cluster-management/seed-sdk/pkg/registry/informers"
	"github.com/open-cluster-management/seed-sdk/pkg/scheme"

	"k8s.io/cluster-registry/pkg/apis/clusterregistry/v1alpha1"
	clclientset "k8s.io/cluster-registry/pkg/client/clientset/versioned"
	clinformer "k8s.io/cluster-registry/pkg/client/informers/externalversions"
	clinternal "k8s.io/cluster-registry/pkg/client/informers/externalversions/internalinterfaces"
)

// ClusterCRD is the CRD for the Cluster
var ClusterCRD = `apiVersion: apiextensions.k8s.io/v1beta1
kind: CustomResourceDefinition
metadata:
  creationTimestamp: null
  labels:
    api: ""
    kubebuilder.k8s.io: 0.1.10
  name: clusters.clusterregistry.k8s.io
spec:
  group: clusterregistry.k8s.io
  names:
    kind: Cluster
    plural: clusters
  scope: Namespaced
  validation:
    openAPIV3Schema:
      properties:
        apiVersion:
          type: string
        kind:
          type: string
        metadata:
          type: object
        spec:
          properties:
            authInfo:
              properties:
                controller:
                  properties:
                    kind:
                      type: string
                    name:
                      type: string
                    namespace:
                      type: string
                  type: object
                user:
                  properties:
                    kind:
                      type: string
                    name:
                      type: string
                    namespace:
                      type: string
                  type: object
              type: object
            kubernetesApiEndpoints:
              properties:
                caBundle:
                  items:
                    type: byte
                  type: string
                serverEndpoints:
                  items:
                    properties:
                      clientCIDR:
                        type: string
                      serverAddress:
                        type: string
                    type: object
                  type: array
              type: object
          type: object
        status:
          properties:
            conditions:
              items:
                properties:
                  lastHeartbeatTime:
                    format: date-time
                    type: string
                  lastTransitionTime:
                    format: date-time
                    type: string
                  message:
                    type: string
                  reason:
                    type: string
                  status:
                    type: string
                  type:
                    type: string
                type: object
              type: array
          type: object
      type: object
  version: v1alpha1
status:
  acceptedNames:
    kind: ""
    plural: ""
  conditions: null`

var CustomResourceDefinitions = &scheme.CRDsInfo{

	SchemeBuilder:              v1alpha1.SchemeBuilder,
	ClientsetName:              "clusters",
	ClientsetConstructor:       newClientsetForConfig,
	InformerFactoryConstructor: newSharedInformerFactory,
	CRDs: map[string]scheme.CRDInfo{
		"clusters.clusterregistry.k8s.io": scheme.CRDInfo{
			Name:   "clusters.clusterregistry.k8s.io",
			RawCRD: ClusterCRD,
		},
	},
}

func newClientsetForConfig(config *rest.Config) (clientsets.Interface, error) {
	return clclientset.NewForConfig(config)
}

func newSharedInformerFactory(clientset clientsets.Interface, defaultResync time.Duration, namespace string, listOptions func(*metav1.ListOptions)) informers.SharedInformerFactory {
	tweak := clinternal.TweakListOptionsFunc(listOptions)
	return clinformer.NewFilteredSharedInformerFactory(clientset.(clclientset.Interface), defaultResync, namespace, tweak).(informers.SharedInformerFactory)
}
