// +build !ignore_autogenerated
// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.
// Code generated by seed. DO NOT EDIT.

package v1alpha1

import "github.com/open-cluster-management/seed-sdk/pkg/scheme"



// ComplianceCRD is the CRD for the Compliance  
var ComplianceCRD = `apiVersion: apiextensions.k8s.io/v1beta1
kind: CustomResourceDefinition
metadata:
  # name must match the spec fields below, and be in the form: <plural>.<group>
  name: compliances.compliance.mcm.ibm.com
spec:
  # group name to use for REST API: /apis/<group>/<version>
  group: compliance.mcm.ibm.com
  # version name to use for REST API: /apis/<group>/<version>
  version: v1alpha1
  # either Namespaced or Cluster
  scope: Namespaced
  names:
    # plural name to be used in the URL: /apis/<group>/<version>/<plural>
    plural: compliances
    # singular name to be used as an alias on the CLI and for display
    singular: compliance
    # kind is normally the CamelCased singular type. Your resource manifests use this.
    kind: Compliance
    # shortNames allow shorter string to match your resource on the CLI
    shortNames:
    - cpl
  validation:
    # openAPIV3Schema is the schema for validating custom objects.
    openAPIV3Schema:
      type: object
      required:
      - apiVersion
      - kind
      - metadata
      - spec
      properties:
        apiVersion:
          type: string
        kind:
          type: string
        metadata:
          type: object
        spec:
          type: object
          required:
          - runtime-rules
          properties:
            ignore:
              type: boolean
            runtime-rules:
              type: array
              items:
                type: object
            conditions:
              type: array
              items:
                type: object
                required:
                  - type
                  - status
                properties:
                  type:
                    type: string
                  status:
                    type: string
                    pattern: '^True$|^False$|^Unknown$'
                  lastTransitionTime:
                    format: date-time
                    type: string
                  reason:
                    type: string
                  message:
                    type: string
        status:
          type: "object"`


var CustomResourceDefinitions = &scheme.CRDsInfo{
	SchemeBuilder: SchemeBuilder,
	CRDs: map[string]scheme.CRDInfo{
		"compliances.compliance.mcm.ibm.com": scheme.CRDInfo{
			Name:   "compliances.compliance.mcm.ibm.com",
			RawCRD: ComplianceCRD,
		},
	},
}