// +build !ignore_autogenerated
// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.
// Code generated by seed. DO NOT EDIT.

package v1alpha1

import "github.com/open-cluster-management/seed-sdk/pkg/scheme"

// PolicyCRD is the CRD for the Policy
var PolicyCRD = `apiVersion: apiextensions.k8s.io/v1beta1
kind: CustomResourceDefinition
metadata:
  # name must match the spec fields below, and be in the form: <plural>.<group>
  name: policies.policy.mcm.ibm.com
spec:
  # group name to use for REST API: /apis/<group>/<version>
  group: policy.mcm.ibm.com
  # version name to use for REST API: /apis/<group>/<version>
  version: v1alpha1
  # either Namespaced or Cluster
  scope: Namespaced
  names:
    # plural name to be used in the URL: /apis/<group>/<version>/<plural>
    plural: policies
    # singular name to be used as an alias on the CLI and for display
    singular: policy
    # kind is normally the CamelCased singular type. Your resource manifests use this.
    kind: Policy
    # shortNames allow shorter string to match your resource on the CLI
    shortNames:
    - pl
  validation:
   # openAPIV3Schema is the schema for validating custom objects.
    openAPIV3Schema:
      properties:
        spec:
          type: object
          properties:
            disabled:
              type: boolean
            remediationAction:
              type: string
              enum:
                - "inform"
                - "enforce"
            role-templates:
              type: array
              items:
                type: object
                properties:
                  complianceType:
                    type: string
                    enum:
                      - "musthave"
                      - "mustnothave"
                      - "mustonlyhave"`

var CustomResourceDefinitions = &scheme.CRDsInfo{
	SchemeBuilder: SchemeBuilder,
	CRDs: map[string]scheme.CRDInfo{
		"policies.policy.mcm.ibm.com": scheme.CRDInfo{
			Name:   "policies.policy.mcm.ibm.com",
			RawCRD: PolicyCRD,
		},
	},
}
