// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.
// Code generated by client-gen. DO NOT EDIT.

package versioned

import (
	accesspolicyv1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/client/clientset/versioned/typed/accesspolicy/v1alpha1"
	compliancev1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/client/clientset/versioned/typed/compliance/v1alpha1"
	policyv1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/client/clientset/versioned/typed/policy/v1alpha1"
	"k8s.io/client-go/discovery"
	"k8s.io/client-go/rest"
	"k8s.io/client-go/util/flowcontrol"
)

type Interface interface {
	Discovery() discovery.DiscoveryInterface
	AccesspolicyV1alpha1() accesspolicyv1alpha1.AccesspolicyV1alpha1Interface
	// Deprecated: please explicitly pick a version if possible.
	Accesspolicy() accesspolicyv1alpha1.AccesspolicyV1alpha1Interface
	ComplianceV1alpha1() compliancev1alpha1.ComplianceV1alpha1Interface
	// Deprecated: please explicitly pick a version if possible.
	Compliance() compliancev1alpha1.ComplianceV1alpha1Interface
	PolicyV1alpha1() policyv1alpha1.PolicyV1alpha1Interface
	// Deprecated: please explicitly pick a version if possible.
	Policy() policyv1alpha1.PolicyV1alpha1Interface
}

// Clientset contains the clients for groups. Each group has exactly one
// version included in a Clientset.
type Clientset struct {
	*discovery.DiscoveryClient
	accesspolicyV1alpha1 *accesspolicyv1alpha1.AccesspolicyV1alpha1Client
	complianceV1alpha1   *compliancev1alpha1.ComplianceV1alpha1Client
	policyV1alpha1       *policyv1alpha1.PolicyV1alpha1Client
}

// AccesspolicyV1alpha1 retrieves the AccesspolicyV1alpha1Client
func (c *Clientset) AccesspolicyV1alpha1() accesspolicyv1alpha1.AccesspolicyV1alpha1Interface {
	return c.accesspolicyV1alpha1
}

// Deprecated: Accesspolicy retrieves the default version of AccesspolicyClient.
// Please explicitly pick a version.
func (c *Clientset) Accesspolicy() accesspolicyv1alpha1.AccesspolicyV1alpha1Interface {
	return c.accesspolicyV1alpha1
}

// ComplianceV1alpha1 retrieves the ComplianceV1alpha1Client
func (c *Clientset) ComplianceV1alpha1() compliancev1alpha1.ComplianceV1alpha1Interface {
	return c.complianceV1alpha1
}

// Deprecated: Compliance retrieves the default version of ComplianceClient.
// Please explicitly pick a version.
func (c *Clientset) Compliance() compliancev1alpha1.ComplianceV1alpha1Interface {
	return c.complianceV1alpha1
}

// PolicyV1alpha1 retrieves the PolicyV1alpha1Client
func (c *Clientset) PolicyV1alpha1() policyv1alpha1.PolicyV1alpha1Interface {
	return c.policyV1alpha1
}

// Deprecated: Policy retrieves the default version of PolicyClient.
// Please explicitly pick a version.
func (c *Clientset) Policy() policyv1alpha1.PolicyV1alpha1Interface {
	return c.policyV1alpha1
}

// Discovery retrieves the DiscoveryClient
func (c *Clientset) Discovery() discovery.DiscoveryInterface {
	if c == nil {
		return nil
	}
	return c.DiscoveryClient
}

// NewForConfig creates a new Clientset for the given config.
func NewForConfig(c *rest.Config) (*Clientset, error) {
	configShallowCopy := *c
	if configShallowCopy.RateLimiter == nil && configShallowCopy.QPS > 0 {
		configShallowCopy.RateLimiter = flowcontrol.NewTokenBucketRateLimiter(configShallowCopy.QPS, configShallowCopy.Burst)
	}
	var cs Clientset
	var err error
	cs.accesspolicyV1alpha1, err = accesspolicyv1alpha1.NewForConfig(&configShallowCopy)
	if err != nil {
		return nil, err
	}
	cs.complianceV1alpha1, err = compliancev1alpha1.NewForConfig(&configShallowCopy)
	if err != nil {
		return nil, err
	}
	cs.policyV1alpha1, err = policyv1alpha1.NewForConfig(&configShallowCopy)
	if err != nil {
		return nil, err
	}
	cs.DiscoveryClient, err = discovery.NewDiscoveryClientForConfig(&configShallowCopy)
	if err != nil {
		return nil, err
	}
	return &cs, nil
}

// NewForConfigOrDie creates a new Clientset for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *Clientset {
	var cs Clientset
	cs.accesspolicyV1alpha1 = accesspolicyv1alpha1.NewForConfigOrDie(c)
	cs.complianceV1alpha1 = compliancev1alpha1.NewForConfigOrDie(c)
	cs.policyV1alpha1 = policyv1alpha1.NewForConfigOrDie(c)

	cs.DiscoveryClient = discovery.NewDiscoveryClientForConfigOrDie(c)
	return &cs
}

// New creates a new Clientset for the given RESTClient.
func New(c rest.Interface) *Clientset {
	var cs Clientset
	cs.accesspolicyV1alpha1 = accesspolicyv1alpha1.New(c)
	cs.complianceV1alpha1 = compliancev1alpha1.New(c)
	cs.policyV1alpha1 = policyv1alpha1.New(c)
	cs.DiscoveryClient = discovery.NewDiscoveryClient(c)
	return &cs
}
