// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.
// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/apis/accesspolicy/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeAccessPolicies implements AccessPolicyInterface
type FakeAccessPolicies struct {
	Fake *FakeAccesspolicyV1alpha1
	ns   string
}

var accesspoliciesResource = schema.GroupVersionResource{Group: "accesspolicy", Version: "v1alpha1", Resource: "accesspolicies"}

var accesspoliciesKind = schema.GroupVersionKind{Group: "accesspolicy", Version: "v1alpha1", Kind: "AccessPolicy"}

// Get takes name of the accessPolicy, and returns the corresponding accessPolicy object, and an error if there is any.
func (c *FakeAccessPolicies) Get(name string, options v1.GetOptions) (result *v1alpha1.AccessPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(accesspoliciesResource, c.ns, name), &v1alpha1.AccessPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.AccessPolicy), err
}

// List takes label and field selectors, and returns the list of AccessPolicies that match those selectors.
func (c *FakeAccessPolicies) List(opts v1.ListOptions) (result *v1alpha1.AccessPolicyList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(accesspoliciesResource, accesspoliciesKind, c.ns, opts), &v1alpha1.AccessPolicyList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.AccessPolicyList{}
	for _, item := range obj.(*v1alpha1.AccessPolicyList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested accessPolicies.
func (c *FakeAccessPolicies) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(accesspoliciesResource, c.ns, opts))

}

// Create takes the representation of a accessPolicy and creates it.  Returns the server's representation of the accessPolicy, and an error, if there is any.
func (c *FakeAccessPolicies) Create(accessPolicy *v1alpha1.AccessPolicy) (result *v1alpha1.AccessPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(accesspoliciesResource, c.ns, accessPolicy), &v1alpha1.AccessPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.AccessPolicy), err
}

// Update takes the representation of a accessPolicy and updates it. Returns the server's representation of the accessPolicy, and an error, if there is any.
func (c *FakeAccessPolicies) Update(accessPolicy *v1alpha1.AccessPolicy) (result *v1alpha1.AccessPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(accesspoliciesResource, c.ns, accessPolicy), &v1alpha1.AccessPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.AccessPolicy), err
}

// Delete takes name of the accessPolicy and deletes it. Returns an error if one occurs.
func (c *FakeAccessPolicies) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(accesspoliciesResource, c.ns, name), &v1alpha1.AccessPolicy{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeAccessPolicies) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(accesspoliciesResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.AccessPolicyList{})
	return err
}

// Patch applies the patch and returns the patched accessPolicy.
func (c *FakeAccessPolicies) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.AccessPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(accesspoliciesResource, c.ns, name, pt, data, subresources...), &v1alpha1.AccessPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.AccessPolicy), err
}
