// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.
// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/apis/compliance/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeCompliances implements ComplianceInterface
type FakeCompliances struct {
	Fake *FakeComplianceV1alpha1
	ns   string
}

var compliancesResource = schema.GroupVersionResource{Group: "compliance", Version: "v1alpha1", Resource: "compliances"}

var compliancesKind = schema.GroupVersionKind{Group: "compliance", Version: "v1alpha1", Kind: "Compliance"}

// Get takes name of the compliance, and returns the corresponding compliance object, and an error if there is any.
func (c *FakeCompliances) Get(name string, options v1.GetOptions) (result *v1alpha1.Compliance, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(compliancesResource, c.ns, name), &v1alpha1.Compliance{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Compliance), err
}

// List takes label and field selectors, and returns the list of Compliances that match those selectors.
func (c *FakeCompliances) List(opts v1.ListOptions) (result *v1alpha1.ComplianceList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(compliancesResource, compliancesKind, c.ns, opts), &v1alpha1.ComplianceList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.ComplianceList{ListMeta: obj.(*v1alpha1.ComplianceList).ListMeta}
	for _, item := range obj.(*v1alpha1.ComplianceList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested compliances.
func (c *FakeCompliances) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(compliancesResource, c.ns, opts))

}

// Create takes the representation of a compliance and creates it.  Returns the server's representation of the compliance, and an error, if there is any.
func (c *FakeCompliances) Create(compliance *v1alpha1.Compliance) (result *v1alpha1.Compliance, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(compliancesResource, c.ns, compliance), &v1alpha1.Compliance{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Compliance), err
}

// Update takes the representation of a compliance and updates it. Returns the server's representation of the compliance, and an error, if there is any.
func (c *FakeCompliances) Update(compliance *v1alpha1.Compliance) (result *v1alpha1.Compliance, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(compliancesResource, c.ns, compliance), &v1alpha1.Compliance{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Compliance), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeCompliances) UpdateStatus(compliance *v1alpha1.Compliance) (*v1alpha1.Compliance, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(compliancesResource, "status", c.ns, compliance), &v1alpha1.Compliance{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Compliance), err
}

// Delete takes name of the compliance and deletes it. Returns an error if one occurs.
func (c *FakeCompliances) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(compliancesResource, c.ns, name), &v1alpha1.Compliance{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeCompliances) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(compliancesResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.ComplianceList{})
	return err
}

// Patch applies the patch and returns the patched compliance.
func (c *FakeCompliances) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.Compliance, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(compliancesResource, c.ns, name, pt, data, subresources...), &v1alpha1.Compliance{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Compliance), err
}
