// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.
// Code generated by informer-gen. DO NOT EDIT.

package v1alpha1

import (
	time "time"

	accesspolicyv1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/apis/accesspolicy/v1alpha1"
	versioned "github.com/open-cluster-management/hcm-compliance/pkg/client/clientset/versioned"
	internalinterfaces "github.com/open-cluster-management/hcm-compliance/pkg/client/informers/externalversions/internalinterfaces"
	v1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/client/listers/accesspolicy/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// AccessPolicyInformer provides access to a shared informer and lister for
// AccessPolicies.
type AccessPolicyInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1alpha1.AccessPolicyLister
}

type accessPolicyInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewAccessPolicyInformer constructs a new informer for AccessPolicy type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewAccessPolicyInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredAccessPolicyInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredAccessPolicyInformer constructs a new informer for AccessPolicy type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredAccessPolicyInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.AccesspolicyV1alpha1().AccessPolicies(namespace).List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.AccesspolicyV1alpha1().AccessPolicies(namespace).Watch(options)
			},
		},
		&accesspolicyv1alpha1.AccessPolicy{},
		resyncPeriod,
		indexers,
	)
}

func (f *accessPolicyInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredAccessPolicyInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *accessPolicyInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&accesspolicyv1alpha1.AccessPolicy{}, f.defaultInformer)
}

func (f *accessPolicyInformer) Lister() v1alpha1.AccessPolicyLister {
	return v1alpha1.NewAccessPolicyLister(f.Informer().GetIndexer())
}
