// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.
// Code generated by informer-gen. DO NOT EDIT.

package v1alpha1

import (
	time "time"

	compliancev1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/apis/compliance/v1alpha1"
	versioned "github.com/open-cluster-management/hcm-compliance/pkg/client/clientset/versioned"
	internalinterfaces "github.com/open-cluster-management/hcm-compliance/pkg/client/informers/externalversions/internalinterfaces"
	v1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/client/listers/compliance/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// ComplianceInformer provides access to a shared informer and lister for
// Compliances.
type ComplianceInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1alpha1.ComplianceLister
}

type complianceInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewComplianceInformer constructs a new informer for Compliance type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewComplianceInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredComplianceInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredComplianceInformer constructs a new informer for Compliance type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredComplianceInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ComplianceV1alpha1().Compliances(namespace).List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ComplianceV1alpha1().Compliances(namespace).Watch(options)
			},
		},
		&compliancev1alpha1.Compliance{},
		resyncPeriod,
		indexers,
	)
}

func (f *complianceInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredComplianceInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *complianceInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&compliancev1alpha1.Compliance{}, f.defaultInformer)
}

func (f *complianceInformer) Lister() v1alpha1.ComplianceLister {
	return v1alpha1.NewComplianceLister(f.Informer().GetIndexer())
}
