// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.
// Code generated by informer-gen. DO NOT EDIT.

package externalversions

import (
	"fmt"

	v1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/apis/accesspolicy/v1alpha1"
	compliancev1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/apis/compliance/v1alpha1"
	policyv1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/apis/policy/v1alpha1"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	cache "k8s.io/client-go/tools/cache"
)

// GenericInformer is type of SharedIndexInformer which will locate and delegate to other
// sharedInformers based on type
type GenericInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() cache.GenericLister
}

type genericInformer struct {
	informer cache.SharedIndexInformer
	resource schema.GroupResource
}

// Informer returns the SharedIndexInformer.
func (f *genericInformer) Informer() cache.SharedIndexInformer {
	return f.informer
}

// Lister returns the GenericLister.
func (f *genericInformer) Lister() cache.GenericLister {
	return cache.NewGenericLister(f.Informer().GetIndexer(), f.resource)
}

// ForResource gives generic access to a shared informer of the matching type
// TODO extend this to unknown resources with a client pool
func (f *sharedInformerFactory) ForResource(resource schema.GroupVersionResource) (GenericInformer, error) {
	switch resource {
	// Group=accesspolicy, Version=v1alpha1
	case v1alpha1.SchemeGroupVersion.WithResource("accesspolicies"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Accesspolicy().V1alpha1().AccessPolicies().Informer()}, nil

		// Group=compliance, Version=v1alpha1
	case compliancev1alpha1.SchemeGroupVersion.WithResource("compliances"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Compliance().V1alpha1().Compliances().Informer()}, nil

		// Group=policy, Version=v1alpha1
	case policyv1alpha1.SchemeGroupVersion.WithResource("policies"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Policy().V1alpha1().Policies().Informer()}, nil

	}

	return nil, fmt.Errorf("no informer found for %v", resource)
}
