// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.
// Copyright (c) 2020 Red Hat, Inc.

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/open-cluster-management/multicloud-operators-placementrule/pkg/apis/apps/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// PlacementRuleLister helps list PlacementRules.
type PlacementRuleLister interface {
	// List lists all PlacementRules in the indexer.
	List(selector labels.Selector) (ret []*v1.PlacementRule, err error)
	// PlacementRules returns an object that can list and get PlacementRules.
	PlacementRules(namespace string) PlacementRuleNamespaceLister
	PlacementRuleListerExpansion
}

// placementRuleLister implements the PlacementRuleLister interface.
type placementRuleLister struct {
	indexer cache.Indexer
}

// NewPlacementRuleLister returns a new PlacementRuleLister.
func NewPlacementRuleLister(indexer cache.Indexer) PlacementRuleLister {
	return &placementRuleLister{indexer: indexer}
}

// List lists all PlacementRules in the indexer.
func (s *placementRuleLister) List(selector labels.Selector) (ret []*v1.PlacementRule, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.PlacementRule))
	})
	return ret, err
}

// PlacementRules returns an object that can list and get PlacementRules.
func (s *placementRuleLister) PlacementRules(namespace string) PlacementRuleNamespaceLister {
	return placementRuleNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// PlacementRuleNamespaceLister helps list and get PlacementRules.
type PlacementRuleNamespaceLister interface {
	// List lists all PlacementRules in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.PlacementRule, err error)
	// Get retrieves the PlacementRule from the indexer for a given namespace and name.
	Get(name string) (*v1.PlacementRule, error)
	PlacementRuleNamespaceListerExpansion
}

// placementRuleNamespaceLister implements the PlacementRuleNamespaceLister
// interface.
type placementRuleNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all PlacementRules in the indexer for a given namespace.
func (s placementRuleNamespaceLister) List(selector labels.Selector) (ret []*v1.PlacementRule, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.PlacementRule))
	})
	return ret, err
}

// Get retrieves the PlacementRule from the indexer for a given namespace and name.
func (s placementRuleNamespaceLister) Get(name string) (*v1.PlacementRule, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("placementrule"), name)
	}
	return obj.(*v1.PlacementRule), nil
}
