// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.
// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/open-cluster-management/hcm-compliance/pkg/apis/compliance/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ComplianceLister helps list Compliances.
type ComplianceLister interface {
	// List lists all Compliances in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.Compliance, err error)
	// Compliances returns an object that can list and get Compliances.
	Compliances(namespace string) ComplianceNamespaceLister
	ComplianceListerExpansion
}

// complianceLister implements the ComplianceLister interface.
type complianceLister struct {
	indexer cache.Indexer
}

// NewComplianceLister returns a new ComplianceLister.
func NewComplianceLister(indexer cache.Indexer) ComplianceLister {
	return &complianceLister{indexer: indexer}
}

// List lists all Compliances in the indexer.
func (s *complianceLister) List(selector labels.Selector) (ret []*v1alpha1.Compliance, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.Compliance))
	})
	return ret, err
}

// Compliances returns an object that can list and get Compliances.
func (s *complianceLister) Compliances(namespace string) ComplianceNamespaceLister {
	return complianceNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ComplianceNamespaceLister helps list and get Compliances.
type ComplianceNamespaceLister interface {
	// List lists all Compliances in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.Compliance, err error)
	// Get retrieves the Compliance from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.Compliance, error)
	ComplianceNamespaceListerExpansion
}

// complianceNamespaceLister implements the ComplianceNamespaceLister
// interface.
type complianceNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Compliances in the indexer for a given namespace.
func (s complianceNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.Compliance, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.Compliance))
	})
	return ret, err
}

// Get retrieves the Compliance from the indexer for a given namespace and name.
func (s complianceNamespaceLister) Get(name string) (*v1alpha1.Compliance, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("compliance"), name)
	}
	return obj.(*v1alpha1.Compliance), nil
}
