// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.13.0
// source: google/cloud/aiplatform/v1beta1/schema/annotation_payload.proto

package schema

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Annotation details specific to image classification.
type ImageClassificationAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource Id of the AnnotationSpec that this Annotation pertains to.
	AnnotationSpecId string `protobuf:"bytes,1,opt,name=annotation_spec_id,json=annotationSpecId,proto3" json:"annotation_spec_id,omitempty"`
	// The display name of the AnnotationSpec that this Annotation pertains to.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *ImageClassificationAnnotation) Reset() {
	*x = ImageClassificationAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageClassificationAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageClassificationAnnotation) ProtoMessage() {}

func (x *ImageClassificationAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageClassificationAnnotation.ProtoReflect.Descriptor instead.
func (*ImageClassificationAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDescGZIP(), []int{0}
}

func (x *ImageClassificationAnnotation) GetAnnotationSpecId() string {
	if x != nil {
		return x.AnnotationSpecId
	}
	return ""
}

func (x *ImageClassificationAnnotation) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Annotation details specific to image object detection.
type ImageBoundingBoxAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource Id of the AnnotationSpec that this Annotation pertains to.
	AnnotationSpecId string `protobuf:"bytes,1,opt,name=annotation_spec_id,json=annotationSpecId,proto3" json:"annotation_spec_id,omitempty"`
	// The display name of the AnnotationSpec that this Annotation pertains to.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The leftmost coordinate of the bounding box.
	XMin float64 `protobuf:"fixed64,3,opt,name=x_min,json=xMin,proto3" json:"x_min,omitempty"`
	// The rightmost coordinate of the bounding box.
	XMax float64 `protobuf:"fixed64,4,opt,name=x_max,json=xMax,proto3" json:"x_max,omitempty"`
	// The topmost coordinate of the bounding box.
	YMin float64 `protobuf:"fixed64,5,opt,name=y_min,json=yMin,proto3" json:"y_min,omitempty"`
	// The bottommost coordinate of the bounding box.
	YMax float64 `protobuf:"fixed64,6,opt,name=y_max,json=yMax,proto3" json:"y_max,omitempty"`
}

func (x *ImageBoundingBoxAnnotation) Reset() {
	*x = ImageBoundingBoxAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageBoundingBoxAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageBoundingBoxAnnotation) ProtoMessage() {}

func (x *ImageBoundingBoxAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageBoundingBoxAnnotation.ProtoReflect.Descriptor instead.
func (*ImageBoundingBoxAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDescGZIP(), []int{1}
}

func (x *ImageBoundingBoxAnnotation) GetAnnotationSpecId() string {
	if x != nil {
		return x.AnnotationSpecId
	}
	return ""
}

func (x *ImageBoundingBoxAnnotation) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ImageBoundingBoxAnnotation) GetXMin() float64 {
	if x != nil {
		return x.XMin
	}
	return 0
}

func (x *ImageBoundingBoxAnnotation) GetXMax() float64 {
	if x != nil {
		return x.XMax
	}
	return 0
}

func (x *ImageBoundingBoxAnnotation) GetYMin() float64 {
	if x != nil {
		return x.YMin
	}
	return 0
}

func (x *ImageBoundingBoxAnnotation) GetYMax() float64 {
	if x != nil {
		return x.YMax
	}
	return 0
}

// Annotation details specific to image segmentation.
type ImageSegmentationAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Annotation:
	//	*ImageSegmentationAnnotation_MaskAnnotation_
	//	*ImageSegmentationAnnotation_PolygonAnnotation_
	//	*ImageSegmentationAnnotation_PolylineAnnotation_
	Annotation isImageSegmentationAnnotation_Annotation `protobuf_oneof:"annotation"`
}

func (x *ImageSegmentationAnnotation) Reset() {
	*x = ImageSegmentationAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageSegmentationAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageSegmentationAnnotation) ProtoMessage() {}

func (x *ImageSegmentationAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageSegmentationAnnotation.ProtoReflect.Descriptor instead.
func (*ImageSegmentationAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDescGZIP(), []int{2}
}

func (m *ImageSegmentationAnnotation) GetAnnotation() isImageSegmentationAnnotation_Annotation {
	if m != nil {
		return m.Annotation
	}
	return nil
}

func (x *ImageSegmentationAnnotation) GetMaskAnnotation() *ImageSegmentationAnnotation_MaskAnnotation {
	if x, ok := x.GetAnnotation().(*ImageSegmentationAnnotation_MaskAnnotation_); ok {
		return x.MaskAnnotation
	}
	return nil
}

func (x *ImageSegmentationAnnotation) GetPolygonAnnotation() *ImageSegmentationAnnotation_PolygonAnnotation {
	if x, ok := x.GetAnnotation().(*ImageSegmentationAnnotation_PolygonAnnotation_); ok {
		return x.PolygonAnnotation
	}
	return nil
}

func (x *ImageSegmentationAnnotation) GetPolylineAnnotation() *ImageSegmentationAnnotation_PolylineAnnotation {
	if x, ok := x.GetAnnotation().(*ImageSegmentationAnnotation_PolylineAnnotation_); ok {
		return x.PolylineAnnotation
	}
	return nil
}

type isImageSegmentationAnnotation_Annotation interface {
	isImageSegmentationAnnotation_Annotation()
}

type ImageSegmentationAnnotation_MaskAnnotation_ struct {
	// Mask based segmentation annotation. Only one mask annotation can exist
	// for one image.
	MaskAnnotation *ImageSegmentationAnnotation_MaskAnnotation `protobuf:"bytes,3,opt,name=mask_annotation,json=maskAnnotation,proto3,oneof"`
}

type ImageSegmentationAnnotation_PolygonAnnotation_ struct {
	// Polygon annotation.
	PolygonAnnotation *ImageSegmentationAnnotation_PolygonAnnotation `protobuf:"bytes,4,opt,name=polygon_annotation,json=polygonAnnotation,proto3,oneof"`
}

type ImageSegmentationAnnotation_PolylineAnnotation_ struct {
	// Polyline annotation.
	PolylineAnnotation *ImageSegmentationAnnotation_PolylineAnnotation `protobuf:"bytes,5,opt,name=polyline_annotation,json=polylineAnnotation,proto3,oneof"`
}

func (*ImageSegmentationAnnotation_MaskAnnotation_) isImageSegmentationAnnotation_Annotation() {}

func (*ImageSegmentationAnnotation_PolygonAnnotation_) isImageSegmentationAnnotation_Annotation() {}

func (*ImageSegmentationAnnotation_PolylineAnnotation_) isImageSegmentationAnnotation_Annotation() {}

// Annotation details specific to text classification.
type TextClassificationAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource Id of the AnnotationSpec that this Annotation pertains to.
	AnnotationSpecId string `protobuf:"bytes,1,opt,name=annotation_spec_id,json=annotationSpecId,proto3" json:"annotation_spec_id,omitempty"`
	// The display name of the AnnotationSpec that this Annotation pertains to.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *TextClassificationAnnotation) Reset() {
	*x = TextClassificationAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextClassificationAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextClassificationAnnotation) ProtoMessage() {}

func (x *TextClassificationAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextClassificationAnnotation.ProtoReflect.Descriptor instead.
func (*TextClassificationAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDescGZIP(), []int{3}
}

func (x *TextClassificationAnnotation) GetAnnotationSpecId() string {
	if x != nil {
		return x.AnnotationSpecId
	}
	return ""
}

func (x *TextClassificationAnnotation) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Annotation details specific to text extraction.
type TextExtractionAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The segment of the text content.
	TextSegment *TextSegment `protobuf:"bytes,1,opt,name=text_segment,json=textSegment,proto3" json:"text_segment,omitempty"`
	// The resource Id of the AnnotationSpec that this Annotation pertains to.
	AnnotationSpecId string `protobuf:"bytes,2,opt,name=annotation_spec_id,json=annotationSpecId,proto3" json:"annotation_spec_id,omitempty"`
	// The display name of the AnnotationSpec that this Annotation pertains to.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *TextExtractionAnnotation) Reset() {
	*x = TextExtractionAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextExtractionAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextExtractionAnnotation) ProtoMessage() {}

func (x *TextExtractionAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextExtractionAnnotation.ProtoReflect.Descriptor instead.
func (*TextExtractionAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDescGZIP(), []int{4}
}

func (x *TextExtractionAnnotation) GetTextSegment() *TextSegment {
	if x != nil {
		return x.TextSegment
	}
	return nil
}

func (x *TextExtractionAnnotation) GetAnnotationSpecId() string {
	if x != nil {
		return x.AnnotationSpecId
	}
	return ""
}

func (x *TextExtractionAnnotation) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// The text segment inside of DataItem.
type TextSegment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Zero-based character index of the first character of the text
	// segment (counting characters from the beginning of the text).
	StartOffset uint64 `protobuf:"varint,1,opt,name=start_offset,json=startOffset,proto3" json:"start_offset,omitempty"`
	// Zero-based character index of the first character past the end of
	// the text segment (counting character from the beginning of the text).
	// The character at the end_offset is NOT included in the text segment.
	EndOffset uint64 `protobuf:"varint,2,opt,name=end_offset,json=endOffset,proto3" json:"end_offset,omitempty"`
	// The text content in the segment for output only.
	Content string `protobuf:"bytes,3,opt,name=content,proto3" json:"content,omitempty"`
}

func (x *TextSegment) Reset() {
	*x = TextSegment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextSegment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextSegment) ProtoMessage() {}

func (x *TextSegment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextSegment.ProtoReflect.Descriptor instead.
func (*TextSegment) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDescGZIP(), []int{5}
}

func (x *TextSegment) GetStartOffset() uint64 {
	if x != nil {
		return x.StartOffset
	}
	return 0
}

func (x *TextSegment) GetEndOffset() uint64 {
	if x != nil {
		return x.EndOffset
	}
	return 0
}

func (x *TextSegment) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

// Annotation details specific to text sentiment.
type TextSentimentAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The sentiment score for text.
	Sentiment int32 `protobuf:"varint,1,opt,name=sentiment,proto3" json:"sentiment,omitempty"`
	// The sentiment max score for text.
	SentimentMax int32 `protobuf:"varint,2,opt,name=sentiment_max,json=sentimentMax,proto3" json:"sentiment_max,omitempty"`
	// The resource Id of the AnnotationSpec that this Annotation pertains to.
	AnnotationSpecId string `protobuf:"bytes,3,opt,name=annotation_spec_id,json=annotationSpecId,proto3" json:"annotation_spec_id,omitempty"`
	// The display name of the AnnotationSpec that this Annotation pertains to.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *TextSentimentAnnotation) Reset() {
	*x = TextSentimentAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextSentimentAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextSentimentAnnotation) ProtoMessage() {}

func (x *TextSentimentAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextSentimentAnnotation.ProtoReflect.Descriptor instead.
func (*TextSentimentAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDescGZIP(), []int{6}
}

func (x *TextSentimentAnnotation) GetSentiment() int32 {
	if x != nil {
		return x.Sentiment
	}
	return 0
}

func (x *TextSentimentAnnotation) GetSentimentMax() int32 {
	if x != nil {
		return x.SentimentMax
	}
	return 0
}

func (x *TextSentimentAnnotation) GetAnnotationSpecId() string {
	if x != nil {
		return x.AnnotationSpecId
	}
	return ""
}

func (x *TextSentimentAnnotation) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Annotation details specific to video classification.
type VideoClassificationAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This Annotation applies to the time period represented by the TimeSegment.
	// If it's not set, the Annotation applies to the whole video.
	TimeSegment *TimeSegment `protobuf:"bytes,1,opt,name=time_segment,json=timeSegment,proto3" json:"time_segment,omitempty"`
	// The resource Id of the AnnotationSpec that this Annotation pertains to.
	AnnotationSpecId string `protobuf:"bytes,2,opt,name=annotation_spec_id,json=annotationSpecId,proto3" json:"annotation_spec_id,omitempty"`
	// The display name of the AnnotationSpec that this Annotation pertains to.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *VideoClassificationAnnotation) Reset() {
	*x = VideoClassificationAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoClassificationAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoClassificationAnnotation) ProtoMessage() {}

func (x *VideoClassificationAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoClassificationAnnotation.ProtoReflect.Descriptor instead.
func (*VideoClassificationAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDescGZIP(), []int{7}
}

func (x *VideoClassificationAnnotation) GetTimeSegment() *TimeSegment {
	if x != nil {
		return x.TimeSegment
	}
	return nil
}

func (x *VideoClassificationAnnotation) GetAnnotationSpecId() string {
	if x != nil {
		return x.AnnotationSpecId
	}
	return ""
}

func (x *VideoClassificationAnnotation) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// A time period inside of a DataItem that has a time dimension (e.g. video).
type TimeSegment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start of the time segment (inclusive), represented as the duration since
	// the start of the DataItem.
	StartTimeOffset *durationpb.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
	// End of the time segment (exclusive), represented as the duration since the
	// start of the DataItem.
	EndTimeOffset *durationpb.Duration `protobuf:"bytes,2,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
}

func (x *TimeSegment) Reset() {
	*x = TimeSegment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeSegment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeSegment) ProtoMessage() {}

func (x *TimeSegment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeSegment.ProtoReflect.Descriptor instead.
func (*TimeSegment) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDescGZIP(), []int{8}
}

func (x *TimeSegment) GetStartTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.StartTimeOffset
	}
	return nil
}

func (x *TimeSegment) GetEndTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.EndTimeOffset
	}
	return nil
}

// Annotation details specific to video object tracking.
type VideoObjectTrackingAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A time (frame) of a video to which this annotation pertains.
	// Represented as the duration since the video's start.
	TimeOffset *durationpb.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// The leftmost coordinate of the bounding box.
	XMin float64 `protobuf:"fixed64,2,opt,name=x_min,json=xMin,proto3" json:"x_min,omitempty"`
	// The rightmost coordinate of the bounding box.
	XMax float64 `protobuf:"fixed64,3,opt,name=x_max,json=xMax,proto3" json:"x_max,omitempty"`
	// The topmost coordinate of the bounding box.
	YMin float64 `protobuf:"fixed64,4,opt,name=y_min,json=yMin,proto3" json:"y_min,omitempty"`
	// The bottommost coordinate of the bounding box.
	YMax float64 `protobuf:"fixed64,5,opt,name=y_max,json=yMax,proto3" json:"y_max,omitempty"`
	// The instance of the object, expressed as a positive integer. Used to track
	// the same object across different frames.
	InstanceId int64 `protobuf:"varint,6,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// The resource Id of the AnnotationSpec that this Annotation pertains to.
	AnnotationSpecId string `protobuf:"bytes,7,opt,name=annotation_spec_id,json=annotationSpecId,proto3" json:"annotation_spec_id,omitempty"`
	// The display name of the AnnotationSpec that this Annotation pertains to.
	DisplayName string `protobuf:"bytes,8,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *VideoObjectTrackingAnnotation) Reset() {
	*x = VideoObjectTrackingAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoObjectTrackingAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoObjectTrackingAnnotation) ProtoMessage() {}

func (x *VideoObjectTrackingAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoObjectTrackingAnnotation.ProtoReflect.Descriptor instead.
func (*VideoObjectTrackingAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDescGZIP(), []int{9}
}

func (x *VideoObjectTrackingAnnotation) GetTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.TimeOffset
	}
	return nil
}

func (x *VideoObjectTrackingAnnotation) GetXMin() float64 {
	if x != nil {
		return x.XMin
	}
	return 0
}

func (x *VideoObjectTrackingAnnotation) GetXMax() float64 {
	if x != nil {
		return x.XMax
	}
	return 0
}

func (x *VideoObjectTrackingAnnotation) GetYMin() float64 {
	if x != nil {
		return x.YMin
	}
	return 0
}

func (x *VideoObjectTrackingAnnotation) GetYMax() float64 {
	if x != nil {
		return x.YMax
	}
	return 0
}

func (x *VideoObjectTrackingAnnotation) GetInstanceId() int64 {
	if x != nil {
		return x.InstanceId
	}
	return 0
}

func (x *VideoObjectTrackingAnnotation) GetAnnotationSpecId() string {
	if x != nil {
		return x.AnnotationSpecId
	}
	return ""
}

func (x *VideoObjectTrackingAnnotation) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Annotation details specific to video action recognition.
type VideoActionRecognitionAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This Annotation applies to the time period represented by the TimeSegment.
	// If it's not set, the Annotation applies to the whole video.
	TimeSegment *TimeSegment `protobuf:"bytes,1,opt,name=time_segment,json=timeSegment,proto3" json:"time_segment,omitempty"`
	// The resource Id of the AnnotationSpec that this Annotation pertains to.
	AnnotationSpecId string `protobuf:"bytes,2,opt,name=annotation_spec_id,json=annotationSpecId,proto3" json:"annotation_spec_id,omitempty"`
	// The display name of the AnnotationSpec that this Annotation pertains to.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *VideoActionRecognitionAnnotation) Reset() {
	*x = VideoActionRecognitionAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoActionRecognitionAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoActionRecognitionAnnotation) ProtoMessage() {}

func (x *VideoActionRecognitionAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoActionRecognitionAnnotation.ProtoReflect.Descriptor instead.
func (*VideoActionRecognitionAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDescGZIP(), []int{10}
}

func (x *VideoActionRecognitionAnnotation) GetTimeSegment() *TimeSegment {
	if x != nil {
		return x.TimeSegment
	}
	return nil
}

func (x *VideoActionRecognitionAnnotation) GetAnnotationSpecId() string {
	if x != nil {
		return x.AnnotationSpecId
	}
	return ""
}

func (x *VideoActionRecognitionAnnotation) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// The mask based segmentation annotation.
type ImageSegmentationAnnotation_MaskAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Google Cloud Storage URI that points to the mask image. The image must be
	// in PNG format. It must have the same size as the DataItem's image. Each
	// pixel in the image mask represents the AnnotationSpec which the pixel in
	// the image DataItem belong to. Each color is mapped to one AnnotationSpec
	// based on annotation_spec_colors.
	MaskGcsUri string `protobuf:"bytes,1,opt,name=mask_gcs_uri,json=maskGcsUri,proto3" json:"mask_gcs_uri,omitempty"`
	// The mapping between color and AnnotationSpec for this Annotation.
	AnnotationSpecColors []*AnnotationSpecColor `protobuf:"bytes,2,rep,name=annotation_spec_colors,json=annotationSpecColors,proto3" json:"annotation_spec_colors,omitempty"`
}

func (x *ImageSegmentationAnnotation_MaskAnnotation) Reset() {
	*x = ImageSegmentationAnnotation_MaskAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageSegmentationAnnotation_MaskAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageSegmentationAnnotation_MaskAnnotation) ProtoMessage() {}

func (x *ImageSegmentationAnnotation_MaskAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageSegmentationAnnotation_MaskAnnotation.ProtoReflect.Descriptor instead.
func (*ImageSegmentationAnnotation_MaskAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDescGZIP(), []int{2, 0}
}

func (x *ImageSegmentationAnnotation_MaskAnnotation) GetMaskGcsUri() string {
	if x != nil {
		return x.MaskGcsUri
	}
	return ""
}

func (x *ImageSegmentationAnnotation_MaskAnnotation) GetAnnotationSpecColors() []*AnnotationSpecColor {
	if x != nil {
		return x.AnnotationSpecColors
	}
	return nil
}

// Represents a polygon in image.
type ImageSegmentationAnnotation_PolygonAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The vertexes are connected one by one and the last vertex is connected to
	// the first one to represent a polygon.
	Vertexes []*Vertex `protobuf:"bytes,1,rep,name=vertexes,proto3" json:"vertexes,omitempty"`
	// The resource Id of the AnnotationSpec that this Annotation pertains to.
	AnnotationSpecId string `protobuf:"bytes,2,opt,name=annotation_spec_id,json=annotationSpecId,proto3" json:"annotation_spec_id,omitempty"`
	// The display name of the AnnotationSpec that this Annotation pertains to.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *ImageSegmentationAnnotation_PolygonAnnotation) Reset() {
	*x = ImageSegmentationAnnotation_PolygonAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageSegmentationAnnotation_PolygonAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageSegmentationAnnotation_PolygonAnnotation) ProtoMessage() {}

func (x *ImageSegmentationAnnotation_PolygonAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageSegmentationAnnotation_PolygonAnnotation.ProtoReflect.Descriptor instead.
func (*ImageSegmentationAnnotation_PolygonAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDescGZIP(), []int{2, 1}
}

func (x *ImageSegmentationAnnotation_PolygonAnnotation) GetVertexes() []*Vertex {
	if x != nil {
		return x.Vertexes
	}
	return nil
}

func (x *ImageSegmentationAnnotation_PolygonAnnotation) GetAnnotationSpecId() string {
	if x != nil {
		return x.AnnotationSpecId
	}
	return ""
}

func (x *ImageSegmentationAnnotation_PolygonAnnotation) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Represents a polyline in image.
type ImageSegmentationAnnotation_PolylineAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The vertexes are connected one by one and the last vertex in not
	// connected to the first one.
	Vertexes []*Vertex `protobuf:"bytes,1,rep,name=vertexes,proto3" json:"vertexes,omitempty"`
	// The resource Id of the AnnotationSpec that this Annotation pertains to.
	AnnotationSpecId string `protobuf:"bytes,2,opt,name=annotation_spec_id,json=annotationSpecId,proto3" json:"annotation_spec_id,omitempty"`
	// The display name of the AnnotationSpec that this Annotation pertains to.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *ImageSegmentationAnnotation_PolylineAnnotation) Reset() {
	*x = ImageSegmentationAnnotation_PolylineAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageSegmentationAnnotation_PolylineAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageSegmentationAnnotation_PolylineAnnotation) ProtoMessage() {}

func (x *ImageSegmentationAnnotation_PolylineAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageSegmentationAnnotation_PolylineAnnotation.ProtoReflect.Descriptor instead.
func (*ImageSegmentationAnnotation_PolylineAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDescGZIP(), []int{2, 2}
}

func (x *ImageSegmentationAnnotation_PolylineAnnotation) GetVertexes() []*Vertex {
	if x != nil {
		return x.Vertexes
	}
	return nil
}

func (x *ImageSegmentationAnnotation_PolylineAnnotation) GetAnnotationSpecId() string {
	if x != nil {
		return x.AnnotationSpecId
	}
	return ""
}

func (x *ImageSegmentationAnnotation_PolylineAnnotation) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

var File_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDesc = []byte{
	0x0a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x1a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f, 0x67, 0x65, 0x6f, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x70, 0x0a, 0x1d, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x10, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x49,
	0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x22, 0xc1, 0x01, 0x0a, 0x1a, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x42, 0x6f,
	0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x10, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x49,
	0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x13, 0x0a, 0x05, 0x78, 0x5f, 0x6d, 0x69, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x04, 0x78, 0x4d, 0x69, 0x6e, 0x12, 0x13, 0x0a, 0x05, 0x78, 0x5f, 0x6d,
	0x61, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x52, 0x04, 0x78, 0x4d, 0x61, 0x78, 0x12, 0x13,
	0x0a, 0x05, 0x79, 0x5f, 0x6d, 0x69, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x52, 0x04, 0x79,
	0x4d, 0x69, 0x6e, 0x12, 0x13, 0x0a, 0x05, 0x79, 0x5f, 0x6d, 0x61, 0x78, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x04, 0x79, 0x4d, 0x61, 0x78, 0x22, 0xce, 0x07, 0x0a, 0x1b, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7d, 0x0a, 0x0f, 0x6d, 0x61, 0x73, 0x6b,
	0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x73, 0x6b, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x6d, 0x61, 0x73, 0x6b, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x86, 0x01, 0x0a, 0x12, 0x70, 0x6f, 0x6c, 0x79,
	0x67, 0x6f, 0x6e, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x6f, 0x6c, 0x79, 0x67, 0x6f,
	0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x11, 0x70,
	0x6f, 0x6c, 0x79, 0x67, 0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x89, 0x01, 0x0a, 0x13, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x56,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x12, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69,
	0x6e, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xa5, 0x01, 0x0a,
	0x0e, 0x4d, 0x61, 0x73, 0x6b, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x20, 0x0a, 0x0c, 0x6d, 0x61, 0x73, 0x6b, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x61, 0x73, 0x6b, 0x47, 0x63, 0x73, 0x55, 0x72,
	0x69, 0x12, 0x71, 0x0a, 0x16, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x70, 0x65, 0x63, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x52, 0x14,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x43, 0x6f,
	0x6c, 0x6f, 0x72, 0x73, 0x1a, 0xb0, 0x01, 0x0a, 0x11, 0x50, 0x6f, 0x6c, 0x79, 0x67, 0x6f, 0x6e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x08, 0x76, 0x65,
	0x72, 0x74, 0x65, 0x78, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x08, 0x76, 0x65,
	0x72, 0x74, 0x65, 0x78, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x10, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70,
	0x65, 0x63, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0xb1, 0x01, 0x0a, 0x12, 0x50, 0x6f, 0x6c, 0x79,
	0x6c, 0x69, 0x6e, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4a,
	0x0a, 0x08, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78,
	0x52, 0x08, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x42, 0x0c, 0x0a, 0x0a, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6f, 0x0a, 0x1c, 0x54, 0x65, 0x78,
	0x74, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x70, 0x65, 0x63, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xc3, 0x01, 0x0a, 0x18, 0x54,
	0x65, 0x78, 0x74, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x0c, 0x74, 0x65, 0x78, 0x74, 0x5f,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x2c, 0x0a, 0x12, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x49, 0x64, 0x12, 0x21, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x22, 0x69, 0x0a, 0x0b, 0x54, 0x65, 0x78, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x21, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x6e, 0x64, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x4f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0xad, 0x01, 0x0a, 0x17,
	0x54, 0x65, 0x78, 0x74, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x65, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x73, 0x65, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x6d, 0x61, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x73, 0x65,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x78, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xc8, 0x01, 0x0a, 0x1d,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a,
	0x0c, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x10, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65,
	0x63, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x97, 0x01, 0x0a, 0x0b, 0x54, 0x69, 0x6d, 0x65, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x45, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x41, 0x0a,
	0x0f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0d, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x22, 0xa1, 0x02, 0x0a, 0x1d, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x13,
	0x0a, 0x05, 0x78, 0x5f, 0x6d, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x04, 0x78,
	0x4d, 0x69, 0x6e, 0x12, 0x13, 0x0a, 0x05, 0x78, 0x5f, 0x6d, 0x61, 0x78, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x04, 0x78, 0x4d, 0x61, 0x78, 0x12, 0x13, 0x0a, 0x05, 0x79, 0x5f, 0x6d, 0x69,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x52, 0x04, 0x79, 0x4d, 0x69, 0x6e, 0x12, 0x13, 0x0a,
	0x05, 0x79, 0x5f, 0x6d, 0x61, 0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x52, 0x04, 0x79, 0x4d,
	0x61, 0x78, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x10, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x49,
	0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x22, 0xcb, 0x01, 0x0a, 0x20, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x0c, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x70, 0x65, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x49, 0x64, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x42, 0x94, 0x01, 0x0a, 0x2a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x42, 0x16, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67,
	0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x3b, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_goTypes = []interface{}{
	(*ImageClassificationAnnotation)(nil),                  // 0: google.cloud.aiplatform.v1beta1.schema.ImageClassificationAnnotation
	(*ImageBoundingBoxAnnotation)(nil),                     // 1: google.cloud.aiplatform.v1beta1.schema.ImageBoundingBoxAnnotation
	(*ImageSegmentationAnnotation)(nil),                    // 2: google.cloud.aiplatform.v1beta1.schema.ImageSegmentationAnnotation
	(*TextClassificationAnnotation)(nil),                   // 3: google.cloud.aiplatform.v1beta1.schema.TextClassificationAnnotation
	(*TextExtractionAnnotation)(nil),                       // 4: google.cloud.aiplatform.v1beta1.schema.TextExtractionAnnotation
	(*TextSegment)(nil),                                    // 5: google.cloud.aiplatform.v1beta1.schema.TextSegment
	(*TextSentimentAnnotation)(nil),                        // 6: google.cloud.aiplatform.v1beta1.schema.TextSentimentAnnotation
	(*VideoClassificationAnnotation)(nil),                  // 7: google.cloud.aiplatform.v1beta1.schema.VideoClassificationAnnotation
	(*TimeSegment)(nil),                                    // 8: google.cloud.aiplatform.v1beta1.schema.TimeSegment
	(*VideoObjectTrackingAnnotation)(nil),                  // 9: google.cloud.aiplatform.v1beta1.schema.VideoObjectTrackingAnnotation
	(*VideoActionRecognitionAnnotation)(nil),               // 10: google.cloud.aiplatform.v1beta1.schema.VideoActionRecognitionAnnotation
	(*ImageSegmentationAnnotation_MaskAnnotation)(nil),     // 11: google.cloud.aiplatform.v1beta1.schema.ImageSegmentationAnnotation.MaskAnnotation
	(*ImageSegmentationAnnotation_PolygonAnnotation)(nil),  // 12: google.cloud.aiplatform.v1beta1.schema.ImageSegmentationAnnotation.PolygonAnnotation
	(*ImageSegmentationAnnotation_PolylineAnnotation)(nil), // 13: google.cloud.aiplatform.v1beta1.schema.ImageSegmentationAnnotation.PolylineAnnotation
	(*durationpb.Duration)(nil),                            // 14: google.protobuf.Duration
	(*AnnotationSpecColor)(nil),                            // 15: google.cloud.aiplatform.v1beta1.schema.AnnotationSpecColor
	(*Vertex)(nil),                                         // 16: google.cloud.aiplatform.v1beta1.schema.Vertex
}
var file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_depIdxs = []int32{
	11, // 0: google.cloud.aiplatform.v1beta1.schema.ImageSegmentationAnnotation.mask_annotation:type_name -> google.cloud.aiplatform.v1beta1.schema.ImageSegmentationAnnotation.MaskAnnotation
	12, // 1: google.cloud.aiplatform.v1beta1.schema.ImageSegmentationAnnotation.polygon_annotation:type_name -> google.cloud.aiplatform.v1beta1.schema.ImageSegmentationAnnotation.PolygonAnnotation
	13, // 2: google.cloud.aiplatform.v1beta1.schema.ImageSegmentationAnnotation.polyline_annotation:type_name -> google.cloud.aiplatform.v1beta1.schema.ImageSegmentationAnnotation.PolylineAnnotation
	5,  // 3: google.cloud.aiplatform.v1beta1.schema.TextExtractionAnnotation.text_segment:type_name -> google.cloud.aiplatform.v1beta1.schema.TextSegment
	8,  // 4: google.cloud.aiplatform.v1beta1.schema.VideoClassificationAnnotation.time_segment:type_name -> google.cloud.aiplatform.v1beta1.schema.TimeSegment
	14, // 5: google.cloud.aiplatform.v1beta1.schema.TimeSegment.start_time_offset:type_name -> google.protobuf.Duration
	14, // 6: google.cloud.aiplatform.v1beta1.schema.TimeSegment.end_time_offset:type_name -> google.protobuf.Duration
	14, // 7: google.cloud.aiplatform.v1beta1.schema.VideoObjectTrackingAnnotation.time_offset:type_name -> google.protobuf.Duration
	8,  // 8: google.cloud.aiplatform.v1beta1.schema.VideoActionRecognitionAnnotation.time_segment:type_name -> google.cloud.aiplatform.v1beta1.schema.TimeSegment
	15, // 9: google.cloud.aiplatform.v1beta1.schema.ImageSegmentationAnnotation.MaskAnnotation.annotation_spec_colors:type_name -> google.cloud.aiplatform.v1beta1.schema.AnnotationSpecColor
	16, // 10: google.cloud.aiplatform.v1beta1.schema.ImageSegmentationAnnotation.PolygonAnnotation.vertexes:type_name -> google.cloud.aiplatform.v1beta1.schema.Vertex
	16, // 11: google.cloud.aiplatform.v1beta1.schema.ImageSegmentationAnnotation.PolylineAnnotation.vertexes:type_name -> google.cloud.aiplatform.v1beta1.schema.Vertex
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_init() }
func file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_schema_annotation_spec_color_proto_init()
	file_google_cloud_aiplatform_v1beta1_schema_geometry_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageClassificationAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageBoundingBoxAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageSegmentationAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextClassificationAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextExtractionAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextSegment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextSentimentAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoClassificationAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeSegment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoObjectTrackingAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoActionRecognitionAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageSegmentationAnnotation_MaskAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageSegmentationAnnotation_PolygonAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageSegmentationAnnotation_PolylineAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*ImageSegmentationAnnotation_MaskAnnotation_)(nil),
		(*ImageSegmentationAnnotation_PolygonAnnotation_)(nil),
		(*ImageSegmentationAnnotation_PolylineAnnotation_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto = out.File
	file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_schema_annotation_payload_proto_depIdxs = nil
}
