// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateServicePrimaryTaskSetInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that hosts
	// the service that the task set exists in.
	//
	// Cluster is a required field
	Cluster *string `locationName:"cluster" type:"string" required:"true"`

	// The short name or full Amazon Resource Name (ARN) of the task set to set
	// as the primary task set in the deployment.
	//
	// PrimaryTaskSet is a required field
	PrimaryTaskSet *string `locationName:"primaryTaskSet" type:"string" required:"true"`

	// The short name or full Amazon Resource Name (ARN) of the service that the
	// task set exists in.
	//
	// Service is a required field
	Service *string `locationName:"service" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateServicePrimaryTaskSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServicePrimaryTaskSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateServicePrimaryTaskSetInput"}

	if s.Cluster == nil {
		invalidParams.Add(aws.NewErrParamRequired("Cluster"))
	}

	if s.PrimaryTaskSet == nil {
		invalidParams.Add(aws.NewErrParamRequired("PrimaryTaskSet"))
	}

	if s.Service == nil {
		invalidParams.Add(aws.NewErrParamRequired("Service"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateServicePrimaryTaskSetOutput struct {
	_ struct{} `type:"structure"`

	// Information about a set of Amazon ECS tasks in either an AWS CodeDeploy or
	// an EXTERNAL deployment. An Amazon ECS task set includes details such as the
	// desired number of tasks, how many tasks are running, and whether the task
	// set serves production traffic.
	TaskSet *TaskSet `locationName:"taskSet" type:"structure"`
}

// String returns the string representation
func (s UpdateServicePrimaryTaskSetOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateServicePrimaryTaskSet = "UpdateServicePrimaryTaskSet"

// UpdateServicePrimaryTaskSetRequest returns a request value for making API operation for
// Amazon EC2 Container Service.
//
// Modifies which task set in a service is the primary task set. Any parameters
// that are updated on the primary task set in a service will transition to
// the service. This is used when a service uses the EXTERNAL deployment controller
// type. For more information, see Amazon ECS Deployment Types (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html)
// in the Amazon Elastic Container Service Developer Guide.
//
//    // Example sending a request using UpdateServicePrimaryTaskSetRequest.
//    req := client.UpdateServicePrimaryTaskSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateServicePrimaryTaskSet
func (c *Client) UpdateServicePrimaryTaskSetRequest(input *UpdateServicePrimaryTaskSetInput) UpdateServicePrimaryTaskSetRequest {
	op := &aws.Operation{
		Name:       opUpdateServicePrimaryTaskSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServicePrimaryTaskSetInput{}
	}

	req := c.newRequest(op, input, &UpdateServicePrimaryTaskSetOutput{})
	return UpdateServicePrimaryTaskSetRequest{Request: req, Input: input, Copy: c.UpdateServicePrimaryTaskSetRequest}
}

// UpdateServicePrimaryTaskSetRequest is the request type for the
// UpdateServicePrimaryTaskSet API operation.
type UpdateServicePrimaryTaskSetRequest struct {
	*aws.Request
	Input *UpdateServicePrimaryTaskSetInput
	Copy  func(*UpdateServicePrimaryTaskSetInput) UpdateServicePrimaryTaskSetRequest
}

// Send marshals and sends the UpdateServicePrimaryTaskSet API request.
func (r UpdateServicePrimaryTaskSetRequest) Send(ctx context.Context) (*UpdateServicePrimaryTaskSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateServicePrimaryTaskSetResponse{
		UpdateServicePrimaryTaskSetOutput: r.Request.Data.(*UpdateServicePrimaryTaskSetOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateServicePrimaryTaskSetResponse is the response type for the
// UpdateServicePrimaryTaskSet API operation.
type UpdateServicePrimaryTaskSetResponse struct {
	*UpdateServicePrimaryTaskSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateServicePrimaryTaskSet request.
func (r *UpdateServicePrimaryTaskSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
