// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package imagebuilder

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateInfrastructureConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The idempotency token used to make this request idempotent.
	//
	// ClientToken is a required field
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" required:"true" idempotencyToken:"true"`

	// The description of the infrastructure configuration.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The instance profile to associate with the instance used to customize your
	// EC2 AMI.
	//
	// InstanceProfileName is a required field
	InstanceProfileName *string `locationName:"instanceProfileName" min:"1" type:"string" required:"true"`

	// The instance types of the infrastructure configuration. You may specify one
	// or more instance types to use for this build, the service will pick one of
	// these instance types based on availability.
	InstanceTypes []string `locationName:"instanceTypes" type:"list"`

	// The key pair of the infrastructure configuration. This can be used to log
	// onto and debug the instance used to create your image.
	KeyPair *string `locationName:"keyPair" min:"1" type:"string"`

	// The logging configuration of the infrastructure configuration.
	Logging *Logging `locationName:"logging" type:"structure"`

	// The name of the infrastructure configuration.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The security group IDs to associate with the instance used to customize your
	// EC2 AMI.
	SecurityGroupIds []string `locationName:"securityGroupIds" type:"list"`

	// The SNS topic on which to send image build events.
	SnsTopicArn *string `locationName:"snsTopicArn" min:"1" type:"string"`

	// The subnet ID to place the instance used to customize your EC2 AMI in.
	SubnetId *string `locationName:"subnetId" min:"1" type:"string"`

	// The tags of the infrastructure configuration.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`

	// The terminate instance on failure setting of the infrastructure configuration.
	// Set to false if you wish for Image Builder to retain the instance used to
	// configure your AMI in the event that the build or test phase of your workflow
	// failed.
	TerminateInstanceOnFailure *bool `locationName:"terminateInstanceOnFailure" type:"boolean"`
}

// String returns the string representation
func (s CreateInfrastructureConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInfrastructureConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateInfrastructureConfigurationInput"}

	if s.ClientToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.InstanceProfileName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceProfileName"))
	}
	if s.InstanceProfileName != nil && len(*s.InstanceProfileName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceProfileName", 1))
	}
	if s.KeyPair != nil && len(*s.KeyPair) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KeyPair", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.SnsTopicArn != nil && len(*s.SnsTopicArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SnsTopicArn", 1))
	}
	if s.SubnetId != nil && len(*s.SubnetId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SubnetId", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.Logging != nil {
		if err := s.Logging.Validate(); err != nil {
			invalidParams.AddNested("Logging", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateInfrastructureConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceProfileName != nil {
		v := *s.InstanceProfileName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "instanceProfileName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceTypes != nil {
		v := s.InstanceTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "instanceTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.KeyPair != nil {
		v := *s.KeyPair

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "keyPair", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Logging != nil {
		v := s.Logging

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "logging", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecurityGroupIds != nil {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "securityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SnsTopicArn != nil {
		v := *s.SnsTopicArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "snsTopicArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SubnetId != nil {
		v := *s.SubnetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "subnetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TerminateInstanceOnFailure != nil {
		v := *s.TerminateInstanceOnFailure

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "terminateInstanceOnFailure", protocol.BoolValue(v), metadata)
	}
	return nil
}

type CreateInfrastructureConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the infrastructure configuration that was
	// created by this request.
	InfrastructureConfigurationArn *string `locationName:"infrastructureConfigurationArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateInfrastructureConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateInfrastructureConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ClientToken != nil {
		v := *s.ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InfrastructureConfigurationArn != nil {
		v := *s.InfrastructureConfigurationArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "infrastructureConfigurationArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "requestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateInfrastructureConfiguration = "CreateInfrastructureConfiguration"

// CreateInfrastructureConfigurationRequest returns a request value for making API operation for
// EC2 Image Builder.
//
// Creates a new infrastructure configuration. An infrastructure configuration
// defines the environment in which your image will be built and tested.
//
//    // Example sending a request using CreateInfrastructureConfigurationRequest.
//    req := client.CreateInfrastructureConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateInfrastructureConfiguration
func (c *Client) CreateInfrastructureConfigurationRequest(input *CreateInfrastructureConfigurationInput) CreateInfrastructureConfigurationRequest {
	op := &aws.Operation{
		Name:       opCreateInfrastructureConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/CreateInfrastructureConfiguration",
	}

	if input == nil {
		input = &CreateInfrastructureConfigurationInput{}
	}

	req := c.newRequest(op, input, &CreateInfrastructureConfigurationOutput{})
	return CreateInfrastructureConfigurationRequest{Request: req, Input: input, Copy: c.CreateInfrastructureConfigurationRequest}
}

// CreateInfrastructureConfigurationRequest is the request type for the
// CreateInfrastructureConfiguration API operation.
type CreateInfrastructureConfigurationRequest struct {
	*aws.Request
	Input *CreateInfrastructureConfigurationInput
	Copy  func(*CreateInfrastructureConfigurationInput) CreateInfrastructureConfigurationRequest
}

// Send marshals and sends the CreateInfrastructureConfiguration API request.
func (r CreateInfrastructureConfigurationRequest) Send(ctx context.Context) (*CreateInfrastructureConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateInfrastructureConfigurationResponse{
		CreateInfrastructureConfigurationOutput: r.Request.Data.(*CreateInfrastructureConfigurationOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateInfrastructureConfigurationResponse is the response type for the
// CreateInfrastructureConfiguration API operation.
type CreateInfrastructureConfigurationResponse struct {
	*CreateInfrastructureConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateInfrastructureConfiguration request.
func (r *CreateInfrastructureConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
