"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const exec_json_1 = require("@kui-shell/client/config.d/exec.json");
function parseCommandContext(str) {
    if (str) {
        try {
            return JSON.parse(str);
        }
        catch (err1) {
            try {
                return str.split('/').filter(_ => _);
            }
            catch (err2) {
                console.error(`Could not parse command context ${str}`, err1, err2);
            }
        }
    }
    return undefined;
}
let _defaultContext = parseCommandContext(process.env.KUI_COMMAND_CONTEXT) || exec_json_1.defaultContext || [];
exports.Context = {
    current: _defaultContext
};
exports.setDefaultCommandContext = (commandContext) => {
    exports.Context.current = _defaultContext = commandContext;
};
function getCurrentContext() {
    return exports.Context.current;
}
exports.getCurrentContext = getCurrentContext;
//# sourceMappingURL=context.js.map