import { CatchAllHandler, Command, CommandTree, CommandTreeResolution, Disambiguator, KResponse, ParsedOptions } from '../models/command';
import { ExecOptions } from '../models/execOptions';
interface CommandModel {
    catchalls: CatchAllHandler<KResponse, ParsedOptions>[];
    read<T extends KResponse, O extends ParsedOptions>(argv: string[], execOptions: ExecOptions, tryCatchalls?: boolean): Promise<CommandTreeResolution<T, O>>;
    forEachNode(fn: (command: Command<KResponse, ParsedOptions>) => void): void;
}
export declare class CommandModelImpl implements CommandModel {
    private readonly _root;
    get root(): CommandTree;
    private readonly _disambiguator;
    get disambiguator(): Disambiguator;
    private readonly _catchalls;
    get catchalls(): CatchAllHandler<KResponse, ParsedOptions>[];
    read<T extends KResponse, O extends ParsedOptions>(argv: string[], execOptions: ExecOptions, tryCatchalls?: boolean): Promise<CommandTreeResolution<T, O>>;
    forEachNode(fn: (command: Command<KResponse, ParsedOptions>) => void): void;
    private newTree;
}
export declare function getModelInternal(): CommandModelImpl;
export declare function getModel(): CommandModel;
export declare function init(): void;
export declare function initIfNeeded(): void;
export {};
