"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('core/capabilities');
debug('loading');
var Media;
(function (Media) {
    Media[Media["Unknown"] = 0] = "Unknown";
    Media[Media["Headless"] = 1] = "Headless";
    Media[Media["Electron"] = 2] = "Electron";
    Media[Media["Browser"] = 3] = "Browser";
})(Media = exports.Media || (exports.Media = {}));
class State {
    constructor() {
        this.assertedLocalAccess = false;
        this.hasLocalAccess = true;
        this.hasProxy = false;
        this.media = Media.Unknown;
        this.validCredentials = {};
    }
}
const state = new State();
exports.setMedia = (media) => {
    debug('setMedia %s', Media[media]);
    state.media = media;
    if (!state.assertedLocalAccess && media === Media.Browser) {
        state.hasLocalAccess = false;
    }
};
exports.getMedia = () => state.media;
exports.isHeadless = () => state.media === Media.Headless;
exports.inElectron = () => state.media === Media.Electron;
exports.inBrowser = () => {
    if (state.media === Media.Browser) {
        return true;
    }
    if (!exports.isHeadless() && typeof document !== 'undefined' && document.body.classList.contains('not-electron')) {
        exports.setMedia(Media.Browser);
        return true;
    }
    else {
        return false;
    }
};
exports.hasProxy = () => state.hasProxy;
exports.assertHasProxy = () => {
    state.hasProxy = true;
};
exports.setHasAuth = (provider, creds) => {
    debug('setHasAuth', provider, creds);
    state.validCredentials[provider] = creds;
};
exports.getAuth = (provider) => state.validCredentials[provider];
exports.getAuthValue = (provider, key) => {
    const model = state.validCredentials[provider];
    return model && model[key];
};
exports.getValidCredentials = () => state.validCredentials;
exports.setValidCredentials = (creds) => {
    debug('setValidCredentials', creds);
    state.validCredentials = creds;
};
exports.hasAuth = (provider) => !!state.validCredentials[provider];
exports.hasLocalAccess = () => {
    return state.hasLocalAccess;
};
exports.assertLocalAccess = () => {
    state.hasLocalAccess = true;
};
//# sourceMappingURL=capabilities.js.map