"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tab_1 = require("../webapp/tab");
const sessionStore_1 = require("../models/sessionStore");
class SymbolTable {
    constructor() {
        this.symbolTableSessionStorageKey = 'kui.symbol_table';
    }
    getSymbolTable() {
        return JSON.parse(sessionStore_1.default().getItem(this.symbolTableSessionStorageKey)) || {};
    }
    read(tab) {
        return this.getSymbolTable()[tab_1.getTabId(tab)] || {};
    }
    write(tab, curDic) {
        const storage = this.getSymbolTable();
        storage[tab_1.getTabId(tab)] = curDic;
        sessionStore_1.default().setItem(this.symbolTableSessionStorageKey, JSON.stringify(storage));
    }
}
exports.SymbolTable = SymbolTable;
exports.default = new SymbolTable();
//# sourceMappingURL=symbol-table.js.map