"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('main/localStorage');
debug('loading');
const fs_1 = require("fs");
const path_1 = require("path");
const userdata_1 = require("../core/userdata");
debug('modules loaded');
exports.default = () => {
    debug('init');
    const userData = path_1.join(userdata_1.userDataDir(), 'kui-local-storage.json');
    debug('userData %s', userData);
    let data;
    try {
        const raw = fs_1.readFileSync(userData).toString();
        try {
            data = JSON.parse(raw);
        }
        catch (err) {
            debug('error parsing userData', raw);
            throw err;
        }
    }
    catch (err) {
        if (err.code === 'ENOENT') {
            data = {};
        }
        else {
            debug('error reading userData');
            throw err;
        }
    }
    debug('parsed userData');
    const flush = () => {
        try {
            debug('flush');
            fs_1.writeFileSync(userData, JSON.stringify(data));
            debug('flush done');
        }
        catch (err) {
            if (err.code === 'ENOENT') {
                debug('we decided not to initialize the store, but a plugin is trying to write to it');
            }
            else {
                console.error(err);
            }
        }
    };
    const self = {
        getItem: (key) => data[key] || null,
        setItem: (key, val) => {
            debug('setItem', key, val);
            data[key] = val;
            flush();
            return val;
        },
        removeItem: (key) => {
            const val = data[key];
            delete data[key];
            flush();
            return val;
        }
    };
    debug('init done');
    return self;
};
//# sourceMappingURL=store.js.map